package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureDNSZoneSpecBuilder extends AzureDNSZoneSpecFluent<AzureDNSZoneSpecBuilder> implements VisitableBuilder<AzureDNSZoneSpec,AzureDNSZoneSpecBuilder>{
  public AzureDNSZoneSpecBuilder() {
    this(false);
  }
  public AzureDNSZoneSpecBuilder(Boolean validationEnabled) {
    this(new AzureDNSZoneSpec(), validationEnabled);
  }
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureDNSZoneSpec(), validationEnabled);
  }
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpecFluent<?> fluent,AzureDNSZoneSpec instance) {
    this(fluent, instance, false);
  }
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpecFluent<?> fluent,AzureDNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureDNSZoneSpec());

    if (instance != null) {
      fluent.withCloudName(instance.getCloudName());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withCloudName(instance.getCloudName());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpec instance) {
    this(instance,false);
  }
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureDNSZoneSpec());

    if (instance != null) {
      this.withCloudName(instance.getCloudName());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withCloudName(instance.getCloudName());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureDNSZoneSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AzureDNSZoneSpec build() {
    AzureDNSZoneSpec buildable = new AzureDNSZoneSpec(fluent.getCloudName(),fluent.buildCredentialsSecretRef(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}