package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureDNSZoneStatusBuilder extends AzureDNSZoneStatusFluent<AzureDNSZoneStatusBuilder> implements VisitableBuilder<AzureDNSZoneStatus,AzureDNSZoneStatusBuilder>{
  public AzureDNSZoneStatusBuilder() {
    this(false);
  }
  public AzureDNSZoneStatusBuilder(Boolean validationEnabled) {
    this(new AzureDNSZoneStatus(), validationEnabled);
  }
  public AzureDNSZoneStatusBuilder(AzureDNSZoneStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureDNSZoneStatusBuilder(AzureDNSZoneStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureDNSZoneStatus(), validationEnabled);
  }
  public AzureDNSZoneStatusBuilder(AzureDNSZoneStatusFluent<?> fluent,AzureDNSZoneStatus instance) {
    this(fluent, instance, false);
  }
  public AzureDNSZoneStatusBuilder(AzureDNSZoneStatusFluent<?> fluent,AzureDNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureDNSZoneStatus());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureDNSZoneStatusBuilder(AzureDNSZoneStatus instance) {
    this(instance,false);
  }
  public AzureDNSZoneStatusBuilder(AzureDNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureDNSZoneStatus());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureDNSZoneStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AzureDNSZoneStatus build() {
    AzureDNSZoneStatus buildable = new AzureDNSZoneStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}