package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BackupConfigFluent<A extends BackupConfigFluent<A>> extends BaseFluent<A>{
  public BackupConfigFluent() {
  }
  public BackupConfigFluent(BackupConfig instance) {
    instance = (instance != null ? instance : new BackupConfig());

    if (instance != null) {
      this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      this.withVelero(instance.getVelero());
      this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      this.withVelero(instance.getVelero());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer minBackupPeriodSeconds;
  private VeleroBackupConfigBuilder velero;
  private Map<String,Object> additionalProperties;
  public Integer getMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds;
  }
  public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
    this.minBackupPeriodSeconds=minBackupPeriodSeconds; return (A) this;
  }
  public boolean hasMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds != null;
  }
  public VeleroBackupConfig buildVelero() {
    return this.velero!=null ?this.velero.build():null;
  }
  public A withVelero(VeleroBackupConfig velero) {
    _visitables.get("velero").remove(this.velero);
    if (velero!=null){ this.velero= new VeleroBackupConfigBuilder(velero); _visitables.get("velero").add(this.velero);} else { this.velero = null; _visitables.get("velero").remove(this.velero); } return (A) this;
  }
  public boolean hasVelero() {
    return this.velero != null;
  }
  public A withNewVelero(Boolean enabled,String namespace) {
    return (A)withVelero(new VeleroBackupConfig(enabled, namespace));
  }
  public VeleroNested<A> withNewVelero() {
    return new VeleroNested(null);
  }
  public VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
    return new VeleroNested(item);
  }
  public VeleroNested<A> editVelero() {
    return withNewVeleroLike(java.util.Optional.ofNullable(buildVelero()).orElse(null));
  }
  public VeleroNested<A> editOrNewVelero() {
    return withNewVeleroLike(java.util.Optional.ofNullable(buildVelero()).orElse(new VeleroBackupConfigBuilder().build()));
  }
  public VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
    return withNewVeleroLike(java.util.Optional.ofNullable(buildVelero()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackupConfigFluent that = (BackupConfigFluent) o;
    if (!java.util.Objects.equals(minBackupPeriodSeconds, that.minBackupPeriodSeconds)) return false;

    if (!java.util.Objects.equals(velero, that.velero)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minBackupPeriodSeconds,  velero,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minBackupPeriodSeconds != null) { sb.append("minBackupPeriodSeconds:"); sb.append(minBackupPeriodSeconds + ","); }
    if (velero != null) { sb.append("velero:"); sb.append(velero + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class VeleroNested<N> extends VeleroBackupConfigFluent<VeleroNested<N>> implements Nested<N>{
    VeleroNested(VeleroBackupConfig item) {
      this.builder = new VeleroBackupConfigBuilder(this, item);
    }
    VeleroBackupConfigBuilder builder;
    public N and() {
      return (N) BackupConfigFluent.this.withVelero(builder.build());
    }
    public N endVelero() {
      return and();
    }
    
  }
  
}