package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BackupReferenceBuilder extends BackupReferenceFluent<BackupReferenceBuilder> implements VisitableBuilder<BackupReference,BackupReferenceBuilder>{
  public BackupReferenceBuilder() {
    this(false);
  }
  public BackupReferenceBuilder(Boolean validationEnabled) {
    this(new BackupReference(), validationEnabled);
  }
  public BackupReferenceBuilder(BackupReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public BackupReferenceBuilder(BackupReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BackupReference(), validationEnabled);
  }
  public BackupReferenceBuilder(BackupReferenceFluent<?> fluent,BackupReference instance) {
    this(fluent, instance, false);
  }
  public BackupReferenceBuilder(BackupReferenceFluent<?> fluent,BackupReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BackupReference());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BackupReferenceBuilder(BackupReference instance) {
    this(instance,false);
  }
  public BackupReferenceBuilder(BackupReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BackupReference());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BackupReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public BackupReference build() {
    BackupReference buildable = new BackupReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}