package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateBundleSpecBuilder extends CertificateBundleSpecFluent<CertificateBundleSpecBuilder> implements VisitableBuilder<CertificateBundleSpec,CertificateBundleSpecBuilder>{
  public CertificateBundleSpecBuilder() {
    this(false);
  }
  public CertificateBundleSpecBuilder(Boolean validationEnabled) {
    this(new CertificateBundleSpec(), validationEnabled);
  }
  public CertificateBundleSpecBuilder(CertificateBundleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateBundleSpecBuilder(CertificateBundleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateBundleSpec(), validationEnabled);
  }
  public CertificateBundleSpecBuilder(CertificateBundleSpecFluent<?> fluent,CertificateBundleSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateBundleSpecBuilder(CertificateBundleSpecFluent<?> fluent,CertificateBundleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateBundleSpec());

    if (instance != null) {
      fluent.withCertificateSecretRef(instance.getCertificateSecretRef());
      fluent.withGenerate(instance.getGenerate());
      fluent.withName(instance.getName());
      fluent.withCertificateSecretRef(instance.getCertificateSecretRef());
      fluent.withGenerate(instance.getGenerate());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateBundleSpecBuilder(CertificateBundleSpec instance) {
    this(instance,false);
  }
  public CertificateBundleSpecBuilder(CertificateBundleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateBundleSpec());

    if (instance != null) {
      this.withCertificateSecretRef(instance.getCertificateSecretRef());
      this.withGenerate(instance.getGenerate());
      this.withName(instance.getName());
      this.withCertificateSecretRef(instance.getCertificateSecretRef());
      this.withGenerate(instance.getGenerate());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateBundleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateBundleSpec build() {
    CertificateBundleSpec buildable = new CertificateBundleSpec(fluent.buildCertificateSecretRef(),fluent.getGenerate(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}