package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterClaimBuilder extends ClusterClaimFluent<ClusterClaimBuilder> implements VisitableBuilder<ClusterClaim,ClusterClaimBuilder>{
  public ClusterClaimBuilder() {
    this(false);
  }
  public ClusterClaimBuilder(Boolean validationEnabled) {
    this(new ClusterClaim(), validationEnabled);
  }
  public ClusterClaimBuilder(ClusterClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimBuilder(ClusterClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterClaim(), validationEnabled);
  }
  public ClusterClaimBuilder(ClusterClaimFluent<?> fluent,ClusterClaim instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimBuilder(ClusterClaimFluent<?> fluent,ClusterClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterClaim());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimBuilder(ClusterClaim instance) {
    this(instance,false);
  }
  public ClusterClaimBuilder(ClusterClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterClaim());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterClaimFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterClaim build() {
    ClusterClaim buildable = new ClusterClaim(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}