package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeploymentListBuilder extends ClusterDeploymentListFluent<ClusterDeploymentListBuilder> implements VisitableBuilder<ClusterDeploymentList,ClusterDeploymentListBuilder>{
  public ClusterDeploymentListBuilder() {
    this(false);
  }
  public ClusterDeploymentListBuilder(Boolean validationEnabled) {
    this(new ClusterDeploymentList(), validationEnabled);
  }
  public ClusterDeploymentListBuilder(ClusterDeploymentListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeploymentListBuilder(ClusterDeploymentListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeploymentList(), validationEnabled);
  }
  public ClusterDeploymentListBuilder(ClusterDeploymentListFluent<?> fluent,ClusterDeploymentList instance) {
    this(fluent, instance, false);
  }
  public ClusterDeploymentListBuilder(ClusterDeploymentListFluent<?> fluent,ClusterDeploymentList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterDeploymentList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeploymentListBuilder(ClusterDeploymentList instance) {
    this(instance,false);
  }
  public ClusterDeploymentListBuilder(ClusterDeploymentList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterDeploymentList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDeploymentListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeploymentList build() {
    ClusterDeploymentList buildable = new ClusterDeploymentList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}