package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeprovisionListBuilder extends ClusterDeprovisionListFluent<ClusterDeprovisionListBuilder> implements VisitableBuilder<ClusterDeprovisionList,ClusterDeprovisionListBuilder>{
  public ClusterDeprovisionListBuilder() {
    this(false);
  }
  public ClusterDeprovisionListBuilder(Boolean validationEnabled) {
    this(new ClusterDeprovisionList(), validationEnabled);
  }
  public ClusterDeprovisionListBuilder(ClusterDeprovisionListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeprovisionListBuilder(ClusterDeprovisionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeprovisionList(), validationEnabled);
  }
  public ClusterDeprovisionListBuilder(ClusterDeprovisionListFluent<?> fluent,ClusterDeprovisionList instance) {
    this(fluent, instance, false);
  }
  public ClusterDeprovisionListBuilder(ClusterDeprovisionListFluent<?> fluent,ClusterDeprovisionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterDeprovisionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeprovisionListBuilder(ClusterDeprovisionList instance) {
    this(instance,false);
  }
  public ClusterDeprovisionListBuilder(ClusterDeprovisionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterDeprovisionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDeprovisionListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeprovisionList build() {
    ClusterDeprovisionList buildable = new ClusterDeprovisionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}