package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeprovisionPlatformBuilder extends ClusterDeprovisionPlatformFluent<ClusterDeprovisionPlatformBuilder> implements VisitableBuilder<ClusterDeprovisionPlatform,ClusterDeprovisionPlatformBuilder>{
  public ClusterDeprovisionPlatformBuilder() {
    this(false);
  }
  public ClusterDeprovisionPlatformBuilder(Boolean validationEnabled) {
    this(new ClusterDeprovisionPlatform(), validationEnabled);
  }
  public ClusterDeprovisionPlatformBuilder(ClusterDeprovisionPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeprovisionPlatformBuilder(ClusterDeprovisionPlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeprovisionPlatform(), validationEnabled);
  }
  public ClusterDeprovisionPlatformBuilder(ClusterDeprovisionPlatformFluent<?> fluent,ClusterDeprovisionPlatform instance) {
    this(fluent, instance, false);
  }
  public ClusterDeprovisionPlatformBuilder(ClusterDeprovisionPlatformFluent<?> fluent,ClusterDeprovisionPlatform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterDeprovisionPlatform());

    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeprovisionPlatformBuilder(ClusterDeprovisionPlatform instance) {
    this(instance,false);
  }
  public ClusterDeprovisionPlatformBuilder(ClusterDeprovisionPlatform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterDeprovisionPlatform());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withVsphere(instance.getVsphere());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDeprovisionPlatformFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeprovisionPlatform build() {
    ClusterDeprovisionPlatform buildable = new ClusterDeprovisionPlatform(fluent.buildAws(),fluent.buildAzure(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildOpenstack(),fluent.buildOvirt(),fluent.buildVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}