package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterImageSetListBuilder extends ClusterImageSetListFluent<ClusterImageSetListBuilder> implements VisitableBuilder<ClusterImageSetList,ClusterImageSetListBuilder>{
  public ClusterImageSetListBuilder() {
    this(false);
  }
  public ClusterImageSetListBuilder(Boolean validationEnabled) {
    this(new ClusterImageSetList(), validationEnabled);
  }
  public ClusterImageSetListBuilder(ClusterImageSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterImageSetListBuilder(ClusterImageSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterImageSetList(), validationEnabled);
  }
  public ClusterImageSetListBuilder(ClusterImageSetListFluent<?> fluent,ClusterImageSetList instance) {
    this(fluent, instance, false);
  }
  public ClusterImageSetListBuilder(ClusterImageSetListFluent<?> fluent,ClusterImageSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterImageSetList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterImageSetListBuilder(ClusterImageSetList instance) {
    this(instance,false);
  }
  public ClusterImageSetListBuilder(ClusterImageSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterImageSetList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterImageSetListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterImageSetList build() {
    ClusterImageSetList buildable = new ClusterImageSetList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}