package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterIngressBuilder extends ClusterIngressFluent<ClusterIngressBuilder> implements VisitableBuilder<ClusterIngress,ClusterIngressBuilder>{
  public ClusterIngressBuilder() {
    this(false);
  }
  public ClusterIngressBuilder(Boolean validationEnabled) {
    this(new ClusterIngress(), validationEnabled);
  }
  public ClusterIngressBuilder(ClusterIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterIngressBuilder(ClusterIngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterIngress(), validationEnabled);
  }
  public ClusterIngressBuilder(ClusterIngressFluent<?> fluent,ClusterIngress instance) {
    this(fluent, instance, false);
  }
  public ClusterIngressBuilder(ClusterIngressFluent<?> fluent,ClusterIngress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterIngress());

    if (instance != null) {
      fluent.withDomain(instance.getDomain());
      fluent.withName(instance.getName());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withRouteSelector(instance.getRouteSelector());
      fluent.withServingCertificate(instance.getServingCertificate());
      fluent.withDomain(instance.getDomain());
      fluent.withName(instance.getName());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withRouteSelector(instance.getRouteSelector());
      fluent.withServingCertificate(instance.getServingCertificate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterIngressBuilder(ClusterIngress instance) {
    this(instance,false);
  }
  public ClusterIngressBuilder(ClusterIngress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterIngress());

    if (instance != null) {
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRouteSelector(instance.getRouteSelector());
      this.withServingCertificate(instance.getServingCertificate());
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRouteSelector(instance.getRouteSelector());
      this.withServingCertificate(instance.getServingCertificate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterIngressFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterIngress build() {
    ClusterIngress buildable = new ClusterIngress(fluent.getDomain(),fluent.getName(),fluent.buildNamespaceSelector(),fluent.buildRouteSelector(),fluent.getServingCertificate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}