package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterIngressFluent<A extends ClusterIngressFluent<A>> extends BaseFluent<A>{
  public ClusterIngressFluent() {
  }
  public ClusterIngressFluent(ClusterIngress instance) {
    instance = (instance != null ? instance : new ClusterIngress());

    if (instance != null) {
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRouteSelector(instance.getRouteSelector());
      this.withServingCertificate(instance.getServingCertificate());
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRouteSelector(instance.getRouteSelector());
      this.withServingCertificate(instance.getServingCertificate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String domain;
  private String name;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder routeSelector;
  private String servingCertificate;
  private Map<String,Object> additionalProperties;
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public boolean hasDomain() {
    return this.domain != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  public LabelSelector buildRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public A withRouteSelector(LabelSelector routeSelector) {
    _visitables.get("routeSelector").remove(this.routeSelector);
    if (routeSelector!=null){ this.routeSelector= new LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} else { this.routeSelector = null; _visitables.get("routeSelector").remove(this.routeSelector); } return (A) this;
  }
  public boolean hasRouteSelector() {
    return this.routeSelector != null;
  }
  public RouteSelectorNested<A> withNewRouteSelector() {
    return new RouteSelectorNested(null);
  }
  public RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
    return new RouteSelectorNested(item);
  }
  public RouteSelectorNested<A> editRouteSelector() {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(null));
  }
  public RouteSelectorNested<A> editOrNewRouteSelector() {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(item));
  }
  public String getServingCertificate() {
    return this.servingCertificate;
  }
  public A withServingCertificate(String servingCertificate) {
    this.servingCertificate=servingCertificate; return (A) this;
  }
  public boolean hasServingCertificate() {
    return this.servingCertificate != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterIngressFluent that = (ClusterIngressFluent) o;
    if (!java.util.Objects.equals(domain, that.domain)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(routeSelector, that.routeSelector)) return false;

    if (!java.util.Objects.equals(servingCertificate, that.servingCertificate)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(domain,  name,  namespaceSelector,  routeSelector,  servingCertificate,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (routeSelector != null) { sb.append("routeSelector:"); sb.append(routeSelector + ","); }
    if (servingCertificate != null) { sb.append("servingCertificate:"); sb.append(servingCertificate + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterIngressFluent.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  public class RouteSelectorNested<N> extends LabelSelectorFluent<RouteSelectorNested<N>> implements Nested<N>{
    RouteSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterIngressFluent.this.withRouteSelector(builder.build());
    }
    public N endRouteSelector() {
      return and();
    }
    
  }
  
}