package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorStateBuilder extends ClusterOperatorStateFluent<ClusterOperatorStateBuilder> implements VisitableBuilder<ClusterOperatorState,ClusterOperatorStateBuilder>{
  public ClusterOperatorStateBuilder() {
    this(false);
  }
  public ClusterOperatorStateBuilder(Boolean validationEnabled) {
    this(new ClusterOperatorState(), validationEnabled);
  }
  public ClusterOperatorStateBuilder(ClusterOperatorStateFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorStateBuilder(ClusterOperatorStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOperatorState(), validationEnabled);
  }
  public ClusterOperatorStateBuilder(ClusterOperatorStateFluent<?> fluent,ClusterOperatorState instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorStateBuilder(ClusterOperatorStateFluent<?> fluent,ClusterOperatorState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterOperatorState());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withName(instance.getName());
      fluent.withConditions(instance.getConditions());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorStateBuilder(ClusterOperatorState instance) {
    this(instance,false);
  }
  public ClusterOperatorStateBuilder(ClusterOperatorState instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterOperatorState());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withName(instance.getName());
      this.withConditions(instance.getConditions());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterOperatorStateFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOperatorState build() {
    ClusterOperatorState buildable = new ClusterOperatorState(fluent.getConditions(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}