package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolBuilder extends ClusterPoolFluent<ClusterPoolBuilder> implements VisitableBuilder<ClusterPool,ClusterPoolBuilder>{
  public ClusterPoolBuilder() {
    this(false);
  }
  public ClusterPoolBuilder(Boolean validationEnabled) {
    this(new ClusterPool(), validationEnabled);
  }
  public ClusterPoolBuilder(ClusterPoolFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolBuilder(ClusterPoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPool(), validationEnabled);
  }
  public ClusterPoolBuilder(ClusterPoolFluent<?> fluent,ClusterPool instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolBuilder(ClusterPoolFluent<?> fluent,ClusterPool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterPool());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolBuilder(ClusterPool instance) {
    this(instance,false);
  }
  public ClusterPoolBuilder(ClusterPool instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterPool());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPool build() {
    ClusterPool buildable = new ClusterPool(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}