package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolClaimLifetimeBuilder extends ClusterPoolClaimLifetimeFluent<ClusterPoolClaimLifetimeBuilder> implements VisitableBuilder<ClusterPoolClaimLifetime,ClusterPoolClaimLifetimeBuilder>{
  public ClusterPoolClaimLifetimeBuilder() {
    this(false);
  }
  public ClusterPoolClaimLifetimeBuilder(Boolean validationEnabled) {
    this(new ClusterPoolClaimLifetime(), validationEnabled);
  }
  public ClusterPoolClaimLifetimeBuilder(ClusterPoolClaimLifetimeFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolClaimLifetimeBuilder(ClusterPoolClaimLifetimeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPoolClaimLifetime(), validationEnabled);
  }
  public ClusterPoolClaimLifetimeBuilder(ClusterPoolClaimLifetimeFluent<?> fluent,ClusterPoolClaimLifetime instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolClaimLifetimeBuilder(ClusterPoolClaimLifetimeFluent<?> fluent,ClusterPoolClaimLifetime instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterPoolClaimLifetime());

    if (instance != null) {
      fluent.withDefault(instance.getDefault());
      fluent.withMaximum(instance.getMaximum());
      fluent.withDefault(instance.getDefault());
      fluent.withMaximum(instance.getMaximum());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolClaimLifetimeBuilder(ClusterPoolClaimLifetime instance) {
    this(instance,false);
  }
  public ClusterPoolClaimLifetimeBuilder(ClusterPoolClaimLifetime instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterPoolClaimLifetime());

    if (instance != null) {
      this.withDefault(instance.getDefault());
      this.withMaximum(instance.getMaximum());
      this.withDefault(instance.getDefault());
      this.withMaximum(instance.getMaximum());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolClaimLifetimeFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPoolClaimLifetime build() {
    ClusterPoolClaimLifetime buildable = new ClusterPoolClaimLifetime(fluent.getDefault(),fluent.getMaximum());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}