package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterPoolSpecFluent<A extends ClusterPoolSpecFluent<A>> extends BaseFluent<A>{
  public ClusterPoolSpecFluent() {
  }
  public ClusterPoolSpecFluent(ClusterPoolSpec instance) {
    instance = (instance != null ? instance : new ClusterPoolSpec());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withBaseDomain(instance.getBaseDomain());
      this.withClaimLifetime(instance.getClaimLifetime());
      this.withHibernateAfter(instance.getHibernateAfter());
      this.withHibernationConfig(instance.getHibernationConfig());
      this.withImageSetRef(instance.getImageSetRef());
      this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
      this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef());
      this.withLabels(instance.getLabels());
      this.withMaxConcurrent(instance.getMaxConcurrent());
      this.withMaxSize(instance.getMaxSize());
      this.withPlatform(instance.getPlatform());
      this.withPullSecretRef(instance.getPullSecretRef());
      this.withRunningCount(instance.getRunningCount());
      this.withSize(instance.getSize());
      this.withSkipMachinePools(instance.getSkipMachinePools());
      this.withAnnotations(instance.getAnnotations());
      this.withBaseDomain(instance.getBaseDomain());
      this.withClaimLifetime(instance.getClaimLifetime());
      this.withHibernateAfter(instance.getHibernateAfter());
      this.withHibernationConfig(instance.getHibernationConfig());
      this.withImageSetRef(instance.getImageSetRef());
      this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
      this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef());
      this.withLabels(instance.getLabels());
      this.withMaxConcurrent(instance.getMaxConcurrent());
      this.withMaxSize(instance.getMaxSize());
      this.withPlatform(instance.getPlatform());
      this.withPullSecretRef(instance.getPullSecretRef());
      this.withRunningCount(instance.getRunningCount());
      this.withSize(instance.getSize());
      this.withSkipMachinePools(instance.getSkipMachinePools());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> annotations;
  private String baseDomain;
  private ClusterPoolClaimLifetimeBuilder claimLifetime;
  private Duration hibernateAfter;
  private HibernationConfigBuilder hibernationConfig;
  private ClusterImageSetReferenceBuilder imageSetRef;
  private Integer installAttemptsLimit;
  private LocalObjectReferenceBuilder installConfigSecretTemplateRef;
  private Map<String,String> labels;
  private Integer maxConcurrent;
  private Integer maxSize;
  private PlatformBuilder platform;
  private LocalObjectReferenceBuilder pullSecretRef;
  private Integer runningCount;
  private Integer size;
  private Boolean skipMachinePools;
  private Map<String,Object> additionalProperties;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public String getBaseDomain() {
    return this.baseDomain;
  }
  public A withBaseDomain(String baseDomain) {
    this.baseDomain=baseDomain; return (A) this;
  }
  public boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  public ClusterPoolClaimLifetime buildClaimLifetime() {
    return this.claimLifetime!=null ?this.claimLifetime.build():null;
  }
  public A withClaimLifetime(ClusterPoolClaimLifetime claimLifetime) {
    _visitables.get("claimLifetime").remove(this.claimLifetime);
    if (claimLifetime!=null){ this.claimLifetime= new ClusterPoolClaimLifetimeBuilder(claimLifetime); _visitables.get("claimLifetime").add(this.claimLifetime);} else { this.claimLifetime = null; _visitables.get("claimLifetime").remove(this.claimLifetime); } return (A) this;
  }
  public boolean hasClaimLifetime() {
    return this.claimLifetime != null;
  }
  public ClaimLifetimeNested<A> withNewClaimLifetime() {
    return new ClaimLifetimeNested(null);
  }
  public ClaimLifetimeNested<A> withNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
    return new ClaimLifetimeNested(item);
  }
  public ClaimLifetimeNested<A> editClaimLifetime() {
    return withNewClaimLifetimeLike(java.util.Optional.ofNullable(buildClaimLifetime()).orElse(null));
  }
  public ClaimLifetimeNested<A> editOrNewClaimLifetime() {
    return withNewClaimLifetimeLike(java.util.Optional.ofNullable(buildClaimLifetime()).orElse(new ClusterPoolClaimLifetimeBuilder().build()));
  }
  public ClaimLifetimeNested<A> editOrNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
    return withNewClaimLifetimeLike(java.util.Optional.ofNullable(buildClaimLifetime()).orElse(item));
  }
  public Duration getHibernateAfter() {
    return this.hibernateAfter;
  }
  public A withHibernateAfter(Duration hibernateAfter) {
    this.hibernateAfter=hibernateAfter; return (A) this;
  }
  public boolean hasHibernateAfter() {
    return this.hibernateAfter != null;
  }
  public HibernationConfig buildHibernationConfig() {
    return this.hibernationConfig!=null ?this.hibernationConfig.build():null;
  }
  public A withHibernationConfig(HibernationConfig hibernationConfig) {
    _visitables.get("hibernationConfig").remove(this.hibernationConfig);
    if (hibernationConfig!=null){ this.hibernationConfig= new HibernationConfigBuilder(hibernationConfig); _visitables.get("hibernationConfig").add(this.hibernationConfig);} else { this.hibernationConfig = null; _visitables.get("hibernationConfig").remove(this.hibernationConfig); } return (A) this;
  }
  public boolean hasHibernationConfig() {
    return this.hibernationConfig != null;
  }
  public HibernationConfigNested<A> withNewHibernationConfig() {
    return new HibernationConfigNested(null);
  }
  public HibernationConfigNested<A> withNewHibernationConfigLike(HibernationConfig item) {
    return new HibernationConfigNested(item);
  }
  public HibernationConfigNested<A> editHibernationConfig() {
    return withNewHibernationConfigLike(java.util.Optional.ofNullable(buildHibernationConfig()).orElse(null));
  }
  public HibernationConfigNested<A> editOrNewHibernationConfig() {
    return withNewHibernationConfigLike(java.util.Optional.ofNullable(buildHibernationConfig()).orElse(new HibernationConfigBuilder().build()));
  }
  public HibernationConfigNested<A> editOrNewHibernationConfigLike(HibernationConfig item) {
    return withNewHibernationConfigLike(java.util.Optional.ofNullable(buildHibernationConfig()).orElse(item));
  }
  public ClusterImageSetReference buildImageSetRef() {
    return this.imageSetRef!=null ?this.imageSetRef.build():null;
  }
  public A withImageSetRef(ClusterImageSetReference imageSetRef) {
    _visitables.get("imageSetRef").remove(this.imageSetRef);
    if (imageSetRef!=null){ this.imageSetRef= new ClusterImageSetReferenceBuilder(imageSetRef); _visitables.get("imageSetRef").add(this.imageSetRef);} else { this.imageSetRef = null; _visitables.get("imageSetRef").remove(this.imageSetRef); } return (A) this;
  }
  public boolean hasImageSetRef() {
    return this.imageSetRef != null;
  }
  public A withNewImageSetRef(String name) {
    return (A)withImageSetRef(new ClusterImageSetReference(name));
  }
  public ImageSetRefNested<A> withNewImageSetRef() {
    return new ImageSetRefNested(null);
  }
  public ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
    return new ImageSetRefNested(item);
  }
  public ImageSetRefNested<A> editImageSetRef() {
    return withNewImageSetRefLike(java.util.Optional.ofNullable(buildImageSetRef()).orElse(null));
  }
  public ImageSetRefNested<A> editOrNewImageSetRef() {
    return withNewImageSetRefLike(java.util.Optional.ofNullable(buildImageSetRef()).orElse(new ClusterImageSetReferenceBuilder().build()));
  }
  public ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
    return withNewImageSetRefLike(java.util.Optional.ofNullable(buildImageSetRef()).orElse(item));
  }
  public Integer getInstallAttemptsLimit() {
    return this.installAttemptsLimit;
  }
  public A withInstallAttemptsLimit(Integer installAttemptsLimit) {
    this.installAttemptsLimit=installAttemptsLimit; return (A) this;
  }
  public boolean hasInstallAttemptsLimit() {
    return this.installAttemptsLimit != null;
  }
  public LocalObjectReference buildInstallConfigSecretTemplateRef() {
    return this.installConfigSecretTemplateRef!=null ?this.installConfigSecretTemplateRef.build():null;
  }
  public A withInstallConfigSecretTemplateRef(LocalObjectReference installConfigSecretTemplateRef) {
    _visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef);
    if (installConfigSecretTemplateRef!=null){ this.installConfigSecretTemplateRef= new LocalObjectReferenceBuilder(installConfigSecretTemplateRef); _visitables.get("installConfigSecretTemplateRef").add(this.installConfigSecretTemplateRef);} else { this.installConfigSecretTemplateRef = null; _visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef); } return (A) this;
  }
  public boolean hasInstallConfigSecretTemplateRef() {
    return this.installConfigSecretTemplateRef != null;
  }
  public A withNewInstallConfigSecretTemplateRef(String name) {
    return (A)withInstallConfigSecretTemplateRef(new LocalObjectReference(name));
  }
  public InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRef() {
    return new InstallConfigSecretTemplateRefNested(null);
  }
  public InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
    return new InstallConfigSecretTemplateRefNested(item);
  }
  public InstallConfigSecretTemplateRefNested<A> editInstallConfigSecretTemplateRef() {
    return withNewInstallConfigSecretTemplateRefLike(java.util.Optional.ofNullable(buildInstallConfigSecretTemplateRef()).orElse(null));
  }
  public InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRef() {
    return withNewInstallConfigSecretTemplateRefLike(java.util.Optional.ofNullable(buildInstallConfigSecretTemplateRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
    return withNewInstallConfigSecretTemplateRefLike(java.util.Optional.ofNullable(buildInstallConfigSecretTemplateRef()).orElse(item));
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public boolean hasLabels() {
    return this.labels != null;
  }
  public Integer getMaxConcurrent() {
    return this.maxConcurrent;
  }
  public A withMaxConcurrent(Integer maxConcurrent) {
    this.maxConcurrent=maxConcurrent; return (A) this;
  }
  public boolean hasMaxConcurrent() {
    return this.maxConcurrent != null;
  }
  public Integer getMaxSize() {
    return this.maxSize;
  }
  public A withMaxSize(Integer maxSize) {
    this.maxSize=maxSize; return (A) this;
  }
  public boolean hasMaxSize() {
    return this.maxSize != null;
  }
  public Platform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(Platform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new PlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public boolean hasPlatform() {
    return this.platform != null;
  }
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  public PlatformNested<A> withNewPlatformLike(Platform item) {
    return new PlatformNested(item);
  }
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new PlatformBuilder().build()));
  }
  public PlatformNested<A> editOrNewPlatformLike(Platform item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  public LocalObjectReference buildPullSecretRef() {
    return this.pullSecretRef!=null ?this.pullSecretRef.build():null;
  }
  public A withPullSecretRef(LocalObjectReference pullSecretRef) {
    _visitables.get("pullSecretRef").remove(this.pullSecretRef);
    if (pullSecretRef!=null){ this.pullSecretRef= new LocalObjectReferenceBuilder(pullSecretRef); _visitables.get("pullSecretRef").add(this.pullSecretRef);} else { this.pullSecretRef = null; _visitables.get("pullSecretRef").remove(this.pullSecretRef); } return (A) this;
  }
  public boolean hasPullSecretRef() {
    return this.pullSecretRef != null;
  }
  public A withNewPullSecretRef(String name) {
    return (A)withPullSecretRef(new LocalObjectReference(name));
  }
  public PullSecretRefNested<A> withNewPullSecretRef() {
    return new PullSecretRefNested(null);
  }
  public PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item) {
    return new PullSecretRefNested(item);
  }
  public PullSecretRefNested<A> editPullSecretRef() {
    return withNewPullSecretRefLike(java.util.Optional.ofNullable(buildPullSecretRef()).orElse(null));
  }
  public PullSecretRefNested<A> editOrNewPullSecretRef() {
    return withNewPullSecretRefLike(java.util.Optional.ofNullable(buildPullSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item) {
    return withNewPullSecretRefLike(java.util.Optional.ofNullable(buildPullSecretRef()).orElse(item));
  }
  public Integer getRunningCount() {
    return this.runningCount;
  }
  public A withRunningCount(Integer runningCount) {
    this.runningCount=runningCount; return (A) this;
  }
  public boolean hasRunningCount() {
    return this.runningCount != null;
  }
  public Integer getSize() {
    return this.size;
  }
  public A withSize(Integer size) {
    this.size=size; return (A) this;
  }
  public boolean hasSize() {
    return this.size != null;
  }
  public Boolean getSkipMachinePools() {
    return this.skipMachinePools;
  }
  public A withSkipMachinePools(Boolean skipMachinePools) {
    this.skipMachinePools=skipMachinePools; return (A) this;
  }
  public boolean hasSkipMachinePools() {
    return this.skipMachinePools != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterPoolSpecFluent that = (ClusterPoolSpecFluent) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;

    if (!java.util.Objects.equals(claimLifetime, that.claimLifetime)) return false;

    if (!java.util.Objects.equals(hibernateAfter, that.hibernateAfter)) return false;

    if (!java.util.Objects.equals(hibernationConfig, that.hibernationConfig)) return false;

    if (!java.util.Objects.equals(imageSetRef, that.imageSetRef)) return false;

    if (!java.util.Objects.equals(installAttemptsLimit, that.installAttemptsLimit)) return false;

    if (!java.util.Objects.equals(installConfigSecretTemplateRef, that.installConfigSecretTemplateRef)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(maxConcurrent, that.maxConcurrent)) return false;

    if (!java.util.Objects.equals(maxSize, that.maxSize)) return false;

    if (!java.util.Objects.equals(platform, that.platform)) return false;

    if (!java.util.Objects.equals(pullSecretRef, that.pullSecretRef)) return false;

    if (!java.util.Objects.equals(runningCount, that.runningCount)) return false;

    if (!java.util.Objects.equals(size, that.size)) return false;

    if (!java.util.Objects.equals(skipMachinePools, that.skipMachinePools)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  baseDomain,  claimLifetime,  hibernateAfter,  hibernationConfig,  imageSetRef,  installAttemptsLimit,  installConfigSecretTemplateRef,  labels,  maxConcurrent,  maxSize,  platform,  pullSecretRef,  runningCount,  size,  skipMachinePools,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (claimLifetime != null) { sb.append("claimLifetime:"); sb.append(claimLifetime + ","); }
    if (hibernateAfter != null) { sb.append("hibernateAfter:"); sb.append(hibernateAfter + ","); }
    if (hibernationConfig != null) { sb.append("hibernationConfig:"); sb.append(hibernationConfig + ","); }
    if (imageSetRef != null) { sb.append("imageSetRef:"); sb.append(imageSetRef + ","); }
    if (installAttemptsLimit != null) { sb.append("installAttemptsLimit:"); sb.append(installAttemptsLimit + ","); }
    if (installConfigSecretTemplateRef != null) { sb.append("installConfigSecretTemplateRef:"); sb.append(installConfigSecretTemplateRef + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (maxConcurrent != null) { sb.append("maxConcurrent:"); sb.append(maxConcurrent + ","); }
    if (maxSize != null) { sb.append("maxSize:"); sb.append(maxSize + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (pullSecretRef != null) { sb.append("pullSecretRef:"); sb.append(pullSecretRef + ","); }
    if (runningCount != null) { sb.append("runningCount:"); sb.append(runningCount + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (skipMachinePools != null) { sb.append("skipMachinePools:"); sb.append(skipMachinePools + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSkipMachinePools() {
    return withSkipMachinePools(true);
  }
  public class ClaimLifetimeNested<N> extends ClusterPoolClaimLifetimeFluent<ClaimLifetimeNested<N>> implements Nested<N>{
    ClaimLifetimeNested(ClusterPoolClaimLifetime item) {
      this.builder = new ClusterPoolClaimLifetimeBuilder(this, item);
    }
    ClusterPoolClaimLifetimeBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluent.this.withClaimLifetime(builder.build());
    }
    public N endClaimLifetime() {
      return and();
    }
    
  }
  public class HibernationConfigNested<N> extends HibernationConfigFluent<HibernationConfigNested<N>> implements Nested<N>{
    HibernationConfigNested(HibernationConfig item) {
      this.builder = new HibernationConfigBuilder(this, item);
    }
    HibernationConfigBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluent.this.withHibernationConfig(builder.build());
    }
    public N endHibernationConfig() {
      return and();
    }
    
  }
  public class ImageSetRefNested<N> extends ClusterImageSetReferenceFluent<ImageSetRefNested<N>> implements Nested<N>{
    ImageSetRefNested(ClusterImageSetReference item) {
      this.builder = new ClusterImageSetReferenceBuilder(this, item);
    }
    ClusterImageSetReferenceBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluent.this.withImageSetRef(builder.build());
    }
    public N endImageSetRef() {
      return and();
    }
    
  }
  public class InstallConfigSecretTemplateRefNested<N> extends LocalObjectReferenceFluent<InstallConfigSecretTemplateRefNested<N>> implements Nested<N>{
    InstallConfigSecretTemplateRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluent.this.withInstallConfigSecretTemplateRef(builder.build());
    }
    public N endInstallConfigSecretTemplateRef() {
      return and();
    }
    
  }
  public class PlatformNested<N> extends PlatformFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluent.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  public class PullSecretRefNested<N> extends LocalObjectReferenceFluent<PullSecretRefNested<N>> implements Nested<N>{
    PullSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluent.this.withPullSecretRef(builder.build());
    }
    public N endPullSecretRef() {
      return and();
    }
    
  }
  
}