package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterProvisionBuilder extends ClusterProvisionFluent<ClusterProvisionBuilder> implements VisitableBuilder<ClusterProvision,ClusterProvisionBuilder>{
  public ClusterProvisionBuilder() {
    this(false);
  }
  public ClusterProvisionBuilder(Boolean validationEnabled) {
    this(new ClusterProvision(), validationEnabled);
  }
  public ClusterProvisionBuilder(ClusterProvisionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterProvisionBuilder(ClusterProvisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterProvision(), validationEnabled);
  }
  public ClusterProvisionBuilder(ClusterProvisionFluent<?> fluent,ClusterProvision instance) {
    this(fluent, instance, false);
  }
  public ClusterProvisionBuilder(ClusterProvisionFluent<?> fluent,ClusterProvision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterProvision());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterProvisionBuilder(ClusterProvision instance) {
    this(instance,false);
  }
  public ClusterProvisionBuilder(ClusterProvision instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterProvision());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterProvisionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterProvision build() {
    ClusterProvision buildable = new ClusterProvision(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}