package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterProvisionStatusBuilder extends ClusterProvisionStatusFluent<ClusterProvisionStatusBuilder> implements VisitableBuilder<ClusterProvisionStatus,ClusterProvisionStatusBuilder>{
  public ClusterProvisionStatusBuilder() {
    this(false);
  }
  public ClusterProvisionStatusBuilder(Boolean validationEnabled) {
    this(new ClusterProvisionStatus(), validationEnabled);
  }
  public ClusterProvisionStatusBuilder(ClusterProvisionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterProvisionStatusBuilder(ClusterProvisionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterProvisionStatus(), validationEnabled);
  }
  public ClusterProvisionStatusBuilder(ClusterProvisionStatusFluent<?> fluent,ClusterProvisionStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterProvisionStatusBuilder(ClusterProvisionStatusFluent<?> fluent,ClusterProvisionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterProvisionStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withJobRef(instance.getJobRef());
      fluent.withConditions(instance.getConditions());
      fluent.withJobRef(instance.getJobRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterProvisionStatusBuilder(ClusterProvisionStatus instance) {
    this(instance,false);
  }
  public ClusterProvisionStatusBuilder(ClusterProvisionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterProvisionStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withJobRef(instance.getJobRef());
      this.withConditions(instance.getConditions());
      this.withJobRef(instance.getJobRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterProvisionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterProvisionStatus build() {
    ClusterProvisionStatus buildable = new ClusterProvisionStatus(fluent.buildConditions(),fluent.buildJobRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}