package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRelocateBuilder extends ClusterRelocateFluent<ClusterRelocateBuilder> implements VisitableBuilder<ClusterRelocate,ClusterRelocateBuilder>{
  public ClusterRelocateBuilder() {
    this(false);
  }
  public ClusterRelocateBuilder(Boolean validationEnabled) {
    this(new ClusterRelocate(), validationEnabled);
  }
  public ClusterRelocateBuilder(ClusterRelocateFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRelocateBuilder(ClusterRelocateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRelocate(), validationEnabled);
  }
  public ClusterRelocateBuilder(ClusterRelocateFluent<?> fluent,ClusterRelocate instance) {
    this(fluent, instance, false);
  }
  public ClusterRelocateBuilder(ClusterRelocateFluent<?> fluent,ClusterRelocate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterRelocate());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRelocateBuilder(ClusterRelocate instance) {
    this(instance,false);
  }
  public ClusterRelocateBuilder(ClusterRelocate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterRelocate());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterRelocateFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRelocate build() {
    ClusterRelocate buildable = new ClusterRelocate(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}