package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRelocateSpecBuilder extends ClusterRelocateSpecFluent<ClusterRelocateSpecBuilder> implements VisitableBuilder<ClusterRelocateSpec,ClusterRelocateSpecBuilder>{
  public ClusterRelocateSpecBuilder() {
    this(false);
  }
  public ClusterRelocateSpecBuilder(Boolean validationEnabled) {
    this(new ClusterRelocateSpec(), validationEnabled);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRelocateSpec(), validationEnabled);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,ClusterRelocateSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,ClusterRelocateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterRelocateSpec());

    if (instance != null) {
      fluent.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      fluent.withKubeconfigSecretRef(instance.getKubeconfigSecretRef());
      fluent.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      fluent.withKubeconfigSecretRef(instance.getKubeconfigSecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpec instance) {
    this(instance,false);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterRelocateSpec());

    if (instance != null) {
      this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      this.withKubeconfigSecretRef(instance.getKubeconfigSecretRef());
      this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      this.withKubeconfigSecretRef(instance.getKubeconfigSecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterRelocateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRelocateSpec build() {
    ClusterRelocateSpec buildable = new ClusterRelocateSpec(fluent.buildClusterDeploymentSelector(),fluent.buildKubeconfigSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}