package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterStateStatusFluent<A extends ClusterStateStatusFluent<A>> extends BaseFluent<A>{
  public ClusterStateStatusFluent() {
  }
  public ClusterStateStatusFluent(ClusterStateStatus instance) {
    instance = (instance != null ? instance : new ClusterStateStatus());

    if (instance != null) {
      this.withClusterOperators(instance.getClusterOperators());
      this.withLastUpdated(instance.getLastUpdated());
      this.withClusterOperators(instance.getClusterOperators());
      this.withLastUpdated(instance.getLastUpdated());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ClusterOperatorStateBuilder> clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();
  private String lastUpdated;
  private Map<String,Object> additionalProperties;
  public A addToClusterOperators(int index,ClusterOperatorState item) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
    if (index < 0 || index >= clusterOperators.size()) { _visitables.get("clusterOperators").add(builder); clusterOperators.add(builder); } else { _visitables.get("clusterOperators").add(index, builder); clusterOperators.add(index, builder);}
    return (A)this;
  }
  public A setToClusterOperators(int index,ClusterOperatorState item) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
    if (index < 0 || index >= clusterOperators.size()) { _visitables.get("clusterOperators").add(builder); clusterOperators.add(builder); } else { _visitables.get("clusterOperators").set(index, builder); clusterOperators.set(index, builder);}
    return (A)this;
  }
  public A addToClusterOperators(io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState... items) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").add(builder);this.clusterOperators.add(builder);} return (A)this;
  }
  public A addAllToClusterOperators(Collection<ClusterOperatorState> items) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").add(builder);this.clusterOperators.add(builder);} return (A)this;
  }
  public A removeFromClusterOperators(io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState... items) {
    if (this.clusterOperators == null) return (A)this;
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").remove(builder); this.clusterOperators.remove(builder);} return (A)this;
  }
  public A removeAllFromClusterOperators(Collection<ClusterOperatorState> items) {
    if (this.clusterOperators == null) return (A)this;
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").remove(builder); this.clusterOperators.remove(builder);} return (A)this;
  }
  public A removeMatchingFromClusterOperators(Predicate<ClusterOperatorStateBuilder> predicate) {
    if (clusterOperators == null) return (A) this;
    final Iterator<ClusterOperatorStateBuilder> each = clusterOperators.iterator();
    final List visitables = _visitables.get("clusterOperators");
    while (each.hasNext()) {
      ClusterOperatorStateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ClusterOperatorState> buildClusterOperators() {
    return clusterOperators != null ? build(clusterOperators) : null;
  }
  public ClusterOperatorState buildClusterOperator(int index) {
    return this.clusterOperators.get(index).build();
  }
  public ClusterOperatorState buildFirstClusterOperator() {
    return this.clusterOperators.get(0).build();
  }
  public ClusterOperatorState buildLastClusterOperator() {
    return this.clusterOperators.get(clusterOperators.size() - 1).build();
  }
  public ClusterOperatorState buildMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
    for (ClusterOperatorStateBuilder item: clusterOperators) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
    for (ClusterOperatorStateBuilder item: clusterOperators) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterOperators(List<ClusterOperatorState> clusterOperators) {
    if (this.clusterOperators != null) { _visitables.get("clusterOperators").clear();}
    if (clusterOperators != null) {this.clusterOperators = new ArrayList(); for (ClusterOperatorState item : clusterOperators){this.addToClusterOperators(item);}} else { this.clusterOperators = null;} return (A) this;
  }
  public A withClusterOperators(io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState... clusterOperators) {
    if (this.clusterOperators != null) {this.clusterOperators.clear(); _visitables.remove("clusterOperators"); }
    if (clusterOperators != null) {for (ClusterOperatorState item :clusterOperators){ this.addToClusterOperators(item);}} return (A) this;
  }
  public boolean hasClusterOperators() {
    return clusterOperators != null && !clusterOperators.isEmpty();
  }
  public ClusterOperatorsNested<A> addNewClusterOperator() {
    return new ClusterOperatorsNested(-1, null);
  }
  public ClusterOperatorsNested<A> addNewClusterOperatorLike(ClusterOperatorState item) {
    return new ClusterOperatorsNested(-1, item);
  }
  public ClusterOperatorsNested<A> setNewClusterOperatorLike(int index,ClusterOperatorState item) {
    return new ClusterOperatorsNested(index, item);
  }
  public ClusterOperatorsNested<A> editClusterOperator(int index) {
    if (clusterOperators.size() <= index) throw new RuntimeException("Can't edit clusterOperators. Index exceeds size.");
    return setNewClusterOperatorLike(index, buildClusterOperator(index));
  }
  public ClusterOperatorsNested<A> editFirstClusterOperator() {
    if (clusterOperators.size() == 0) throw new RuntimeException("Can't edit first clusterOperators. The list is empty.");
    return setNewClusterOperatorLike(0, buildClusterOperator(0));
  }
  public ClusterOperatorsNested<A> editLastClusterOperator() {
    int index = clusterOperators.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterOperators. The list is empty.");
    return setNewClusterOperatorLike(index, buildClusterOperator(index));
  }
  public ClusterOperatorsNested<A> editMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterOperators.size();i++) { 
    if (predicate.test(clusterOperators.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterOperators. No match found.");
    return setNewClusterOperatorLike(index, buildClusterOperator(index));
  }
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated=lastUpdated; return (A) this;
  }
  public boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterStateStatusFluent that = (ClusterStateStatusFluent) o;
    if (!java.util.Objects.equals(clusterOperators, that.clusterOperators)) return false;

    if (!java.util.Objects.equals(lastUpdated, that.lastUpdated)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterOperators,  lastUpdated,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterOperators != null && !clusterOperators.isEmpty()) { sb.append("clusterOperators:"); sb.append(clusterOperators + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterOperatorsNested<N> extends ClusterOperatorStateFluent<ClusterOperatorsNested<N>> implements Nested<N>{
    ClusterOperatorsNested(int index,ClusterOperatorState item) {
      this.index = index;
      this.builder = new ClusterOperatorStateBuilder(this, item);
    }
    ClusterOperatorStateBuilder builder;
    int index;
    public N and() {
      return (N) ClusterStateStatusFluent.this.setToClusterOperators(index,builder.build());
    }
    public N endClusterOperator() {
      return and();
    }
    
  }
  
}