package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControlPlaneAdditionalCertificateBuilder extends ControlPlaneAdditionalCertificateFluent<ControlPlaneAdditionalCertificateBuilder> implements VisitableBuilder<ControlPlaneAdditionalCertificate,ControlPlaneAdditionalCertificateBuilder>{
  public ControlPlaneAdditionalCertificateBuilder() {
    this(false);
  }
  public ControlPlaneAdditionalCertificateBuilder(Boolean validationEnabled) {
    this(new ControlPlaneAdditionalCertificate(), validationEnabled);
  }
  public ControlPlaneAdditionalCertificateBuilder(ControlPlaneAdditionalCertificateFluent<?> fluent) {
    this(fluent, false);
  }
  public ControlPlaneAdditionalCertificateBuilder(ControlPlaneAdditionalCertificateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControlPlaneAdditionalCertificate(), validationEnabled);
  }
  public ControlPlaneAdditionalCertificateBuilder(ControlPlaneAdditionalCertificateFluent<?> fluent,ControlPlaneAdditionalCertificate instance) {
    this(fluent, instance, false);
  }
  public ControlPlaneAdditionalCertificateBuilder(ControlPlaneAdditionalCertificateFluent<?> fluent,ControlPlaneAdditionalCertificate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ControlPlaneAdditionalCertificate());

    if (instance != null) {
      fluent.withDomain(instance.getDomain());
      fluent.withName(instance.getName());
      fluent.withDomain(instance.getDomain());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ControlPlaneAdditionalCertificateBuilder(ControlPlaneAdditionalCertificate instance) {
    this(instance,false);
  }
  public ControlPlaneAdditionalCertificateBuilder(ControlPlaneAdditionalCertificate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ControlPlaneAdditionalCertificate());

    if (instance != null) {
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withDomain(instance.getDomain());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ControlPlaneAdditionalCertificateFluent<?> fluent;
  Boolean validationEnabled;
  public ControlPlaneAdditionalCertificate build() {
    ControlPlaneAdditionalCertificate buildable = new ControlPlaneAdditionalCertificate(fluent.getDomain(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}