package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllersConfigBuilder extends ControllersConfigFluent<ControllersConfigBuilder> implements VisitableBuilder<ControllersConfig,ControllersConfigBuilder>{
  public ControllersConfigBuilder() {
    this(false);
  }
  public ControllersConfigBuilder(Boolean validationEnabled) {
    this(new ControllersConfig(), validationEnabled);
  }
  public ControllersConfigBuilder(ControllersConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllersConfigBuilder(ControllersConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllersConfig(), validationEnabled);
  }
  public ControllersConfigBuilder(ControllersConfigFluent<?> fluent,ControllersConfig instance) {
    this(fluent, instance, false);
  }
  public ControllersConfigBuilder(ControllersConfigFluent<?> fluent,ControllersConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ControllersConfig());

    if (instance != null) {
      fluent.withControllers(instance.getControllers());
      fluent.withDefault(instance.getDefault());
      fluent.withControllers(instance.getControllers());
      fluent.withDefault(instance.getDefault());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ControllersConfigBuilder(ControllersConfig instance) {
    this(instance,false);
  }
  public ControllersConfigBuilder(ControllersConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ControllersConfig());

    if (instance != null) {
      this.withControllers(instance.getControllers());
      this.withDefault(instance.getDefault());
      this.withControllers(instance.getControllers());
      this.withDefault(instance.getDefault());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ControllersConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ControllersConfig build() {
    ControllersConfig buildable = new ControllersConfig(fluent.buildControllers(),fluent.buildDefault());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}