package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneListBuilder extends DNSZoneListFluent<DNSZoneListBuilder> implements VisitableBuilder<DNSZoneList,DNSZoneListBuilder>{
  public DNSZoneListBuilder() {
    this(false);
  }
  public DNSZoneListBuilder(Boolean validationEnabled) {
    this(new DNSZoneList(), validationEnabled);
  }
  public DNSZoneListBuilder(DNSZoneListFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneListBuilder(DNSZoneListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZoneList(), validationEnabled);
  }
  public DNSZoneListBuilder(DNSZoneListFluent<?> fluent,DNSZoneList instance) {
    this(fluent, instance, false);
  }
  public DNSZoneListBuilder(DNSZoneListFluent<?> fluent,DNSZoneList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSZoneList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneListBuilder(DNSZoneList instance) {
    this(instance,false);
  }
  public DNSZoneListBuilder(DNSZoneList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSZoneList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSZoneListFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZoneList build() {
    DNSZoneList buildable = new DNSZoneList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}