package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSZoneSpecFluent<A extends DNSZoneSpecFluent<A>> extends BaseFluent<A>{
  public DNSZoneSpecFluent() {
  }
  public DNSZoneSpecFluent(DNSZoneSpec instance) {
    instance = (instance != null ? instance : new DNSZoneSpec());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withLinkToParentDomain(instance.getLinkToParentDomain());
      this.withPreserveOnDelete(instance.getPreserveOnDelete());
      this.withZone(instance.getZone());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withLinkToParentDomain(instance.getLinkToParentDomain());
      this.withPreserveOnDelete(instance.getPreserveOnDelete());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AWSDNSZoneSpecBuilder aws;
  private AzureDNSZoneSpecBuilder azure;
  private GCPDNSZoneSpecBuilder gcp;
  private Boolean linkToParentDomain;
  private Boolean preserveOnDelete;
  private String zone;
  private Map<String,Object> additionalProperties;
  public AWSDNSZoneSpec buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSDNSZoneSpec aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSDNSZoneSpecBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public boolean hasAws() {
    return this.aws != null;
  }
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  public AwsNested<A> withNewAwsLike(AWSDNSZoneSpec item) {
    return new AwsNested(item);
  }
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AWSDNSZoneSpecBuilder().build()));
  }
  public AwsNested<A> editOrNewAwsLike(AWSDNSZoneSpec item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  public AzureDNSZoneSpec buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(AzureDNSZoneSpec azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzureDNSZoneSpecBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public boolean hasAzure() {
    return this.azure != null;
  }
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  public AzureNested<A> withNewAzureLike(AzureDNSZoneSpec item) {
    return new AzureNested(item);
  }
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new AzureDNSZoneSpecBuilder().build()));
  }
  public AzureNested<A> editOrNewAzureLike(AzureDNSZoneSpec item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  public GCPDNSZoneSpec buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPDNSZoneSpec gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPDNSZoneSpecBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public boolean hasGcp() {
    return this.gcp != null;
  }
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  public GcpNested<A> withNewGcpLike(GCPDNSZoneSpec item) {
    return new GcpNested(item);
  }
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new GCPDNSZoneSpecBuilder().build()));
  }
  public GcpNested<A> editOrNewGcpLike(GCPDNSZoneSpec item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  public Boolean getLinkToParentDomain() {
    return this.linkToParentDomain;
  }
  public A withLinkToParentDomain(Boolean linkToParentDomain) {
    this.linkToParentDomain=linkToParentDomain; return (A) this;
  }
  public boolean hasLinkToParentDomain() {
    return this.linkToParentDomain != null;
  }
  public Boolean getPreserveOnDelete() {
    return this.preserveOnDelete;
  }
  public A withPreserveOnDelete(Boolean preserveOnDelete) {
    this.preserveOnDelete=preserveOnDelete; return (A) this;
  }
  public boolean hasPreserveOnDelete() {
    return this.preserveOnDelete != null;
  }
  public String getZone() {
    return this.zone;
  }
  public A withZone(String zone) {
    this.zone=zone; return (A) this;
  }
  public boolean hasZone() {
    return this.zone != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSZoneSpecFluent that = (DNSZoneSpecFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;

    if (!java.util.Objects.equals(azure, that.azure)) return false;

    if (!java.util.Objects.equals(gcp, that.gcp)) return false;

    if (!java.util.Objects.equals(linkToParentDomain, that.linkToParentDomain)) return false;

    if (!java.util.Objects.equals(preserveOnDelete, that.preserveOnDelete)) return false;

    if (!java.util.Objects.equals(zone, that.zone)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  gcp,  linkToParentDomain,  preserveOnDelete,  zone,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (linkToParentDomain != null) { sb.append("linkToParentDomain:"); sb.append(linkToParentDomain + ","); }
    if (preserveOnDelete != null) { sb.append("preserveOnDelete:"); sb.append(preserveOnDelete + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withLinkToParentDomain() {
    return withLinkToParentDomain(true);
  }
  public A withPreserveOnDelete() {
    return withPreserveOnDelete(true);
  }
  public class AwsNested<N> extends AWSDNSZoneSpecFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AWSDNSZoneSpec item) {
      this.builder = new AWSDNSZoneSpecBuilder(this, item);
    }
    AWSDNSZoneSpecBuilder builder;
    public N and() {
      return (N) DNSZoneSpecFluent.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  public class AzureNested<N> extends AzureDNSZoneSpecFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(AzureDNSZoneSpec item) {
      this.builder = new AzureDNSZoneSpecBuilder(this, item);
    }
    AzureDNSZoneSpecBuilder builder;
    public N and() {
      return (N) DNSZoneSpecFluent.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  public class GcpNested<N> extends GCPDNSZoneSpecFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(GCPDNSZoneSpec item) {
      this.builder = new GCPDNSZoneSpecBuilder(this, item);
    }
    GCPDNSZoneSpecBuilder builder;
    public N and() {
      return (N) DNSZoneSpecFluent.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  
}