package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateSelectionBuilder extends FeatureGateSelectionFluent<FeatureGateSelectionBuilder> implements VisitableBuilder<FeatureGateSelection,FeatureGateSelectionBuilder>{
  public FeatureGateSelectionBuilder() {
    this(false);
  }
  public FeatureGateSelectionBuilder(Boolean validationEnabled) {
    this(new FeatureGateSelection(), validationEnabled);
  }
  public FeatureGateSelectionBuilder(FeatureGateSelectionFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateSelectionBuilder(FeatureGateSelectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateSelection(), validationEnabled);
  }
  public FeatureGateSelectionBuilder(FeatureGateSelectionFluent<?> fluent,FeatureGateSelection instance) {
    this(fluent, instance, false);
  }
  public FeatureGateSelectionBuilder(FeatureGateSelectionFluent<?> fluent,FeatureGateSelection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FeatureGateSelection());

    if (instance != null) {
      fluent.withCustom(instance.getCustom());
      fluent.withFeatureSet(instance.getFeatureSet());
      fluent.withCustom(instance.getCustom());
      fluent.withFeatureSet(instance.getFeatureSet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateSelectionBuilder(FeatureGateSelection instance) {
    this(instance,false);
  }
  public FeatureGateSelectionBuilder(FeatureGateSelection instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FeatureGateSelection());

    if (instance != null) {
      this.withCustom(instance.getCustom());
      this.withFeatureSet(instance.getFeatureSet());
      this.withCustom(instance.getCustom());
      this.withFeatureSet(instance.getFeatureSet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateSelectionFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateSelection build() {
    FeatureGateSelection buildable = new FeatureGateSelection(fluent.buildCustom(),fluent.getFeatureSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}