package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPClusterDeprovisionBuilder extends GCPClusterDeprovisionFluent<GCPClusterDeprovisionBuilder> implements VisitableBuilder<GCPClusterDeprovision,GCPClusterDeprovisionBuilder>{
  public GCPClusterDeprovisionBuilder() {
    this(false);
  }
  public GCPClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new GCPClusterDeprovision(), validationEnabled);
  }
  public GCPClusterDeprovisionBuilder(GCPClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPClusterDeprovisionBuilder(GCPClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPClusterDeprovision(), validationEnabled);
  }
  public GCPClusterDeprovisionBuilder(GCPClusterDeprovisionFluent<?> fluent,GCPClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public GCPClusterDeprovisionBuilder(GCPClusterDeprovisionFluent<?> fluent,GCPClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GCPClusterDeprovision());

    if (instance != null) {
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withRegion(instance.getRegion());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withRegion(instance.getRegion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCPClusterDeprovisionBuilder(GCPClusterDeprovision instance) {
    this(instance,false);
  }
  public GCPClusterDeprovisionBuilder(GCPClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GCPClusterDeprovision());

    if (instance != null) {
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCPClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public GCPClusterDeprovision build() {
    GCPClusterDeprovision buildable = new GCPClusterDeprovision(fluent.buildCredentialsSecretRef(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}