package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HiveConfigConditionBuilder extends HiveConfigConditionFluent<HiveConfigConditionBuilder> implements VisitableBuilder<HiveConfigCondition,HiveConfigConditionBuilder>{
  public HiveConfigConditionBuilder() {
    this(false);
  }
  public HiveConfigConditionBuilder(Boolean validationEnabled) {
    this(new HiveConfigCondition(), validationEnabled);
  }
  public HiveConfigConditionBuilder(HiveConfigConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public HiveConfigConditionBuilder(HiveConfigConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HiveConfigCondition(), validationEnabled);
  }
  public HiveConfigConditionBuilder(HiveConfigConditionFluent<?> fluent,HiveConfigCondition instance) {
    this(fluent, instance, false);
  }
  public HiveConfigConditionBuilder(HiveConfigConditionFluent<?> fluent,HiveConfigCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HiveConfigCondition());

    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HiveConfigConditionBuilder(HiveConfigCondition instance) {
    this(instance,false);
  }
  public HiveConfigConditionBuilder(HiveConfigCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HiveConfigCondition());

    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HiveConfigConditionFluent<?> fluent;
  Boolean validationEnabled;
  public HiveConfigCondition build() {
    HiveConfigCondition buildable = new HiveConfigCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}