package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HiveConfigListBuilder extends HiveConfigListFluent<HiveConfigListBuilder> implements VisitableBuilder<HiveConfigList,HiveConfigListBuilder>{
  public HiveConfigListBuilder() {
    this(false);
  }
  public HiveConfigListBuilder(Boolean validationEnabled) {
    this(new HiveConfigList(), validationEnabled);
  }
  public HiveConfigListBuilder(HiveConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public HiveConfigListBuilder(HiveConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HiveConfigList(), validationEnabled);
  }
  public HiveConfigListBuilder(HiveConfigListFluent<?> fluent,HiveConfigList instance) {
    this(fluent, instance, false);
  }
  public HiveConfigListBuilder(HiveConfigListFluent<?> fluent,HiveConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HiveConfigList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HiveConfigListBuilder(HiveConfigList instance) {
    this(instance,false);
  }
  public HiveConfigListBuilder(HiveConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HiveConfigList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HiveConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public HiveConfigList build() {
    HiveConfigList buildable = new HiveConfigList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}