package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IBMClusterDeprovisionBuilder extends IBMClusterDeprovisionFluent<IBMClusterDeprovisionBuilder> implements VisitableBuilder<IBMClusterDeprovision,IBMClusterDeprovisionBuilder>{
  public IBMClusterDeprovisionBuilder() {
    this(false);
  }
  public IBMClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new IBMClusterDeprovision(), validationEnabled);
  }
  public IBMClusterDeprovisionBuilder(IBMClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public IBMClusterDeprovisionBuilder(IBMClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IBMClusterDeprovision(), validationEnabled);
  }
  public IBMClusterDeprovisionBuilder(IBMClusterDeprovisionFluent<?> fluent,IBMClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public IBMClusterDeprovisionBuilder(IBMClusterDeprovisionFluent<?> fluent,IBMClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IBMClusterDeprovision());

    if (instance != null) {
      fluent.withAccountID(instance.getAccountID());
      fluent.withBaseDomain(instance.getBaseDomain());
      fluent.withCisInstanceCRN(instance.getCisInstanceCRN());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withRegion(instance.getRegion());
      fluent.withAccountID(instance.getAccountID());
      fluent.withBaseDomain(instance.getBaseDomain());
      fluent.withCisInstanceCRN(instance.getCisInstanceCRN());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withRegion(instance.getRegion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IBMClusterDeprovisionBuilder(IBMClusterDeprovision instance) {
    this(instance,false);
  }
  public IBMClusterDeprovisionBuilder(IBMClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IBMClusterDeprovision());

    if (instance != null) {
      this.withAccountID(instance.getAccountID());
      this.withBaseDomain(instance.getBaseDomain());
      this.withCisInstanceCRN(instance.getCisInstanceCRN());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withAccountID(instance.getAccountID());
      this.withBaseDomain(instance.getBaseDomain());
      this.withCisInstanceCRN(instance.getCisInstanceCRN());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IBMClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public IBMClusterDeprovision build() {
    IBMClusterDeprovision buildable = new IBMClusterDeprovision(fluent.getAccountID(),fluent.getBaseDomain(),fluent.getCisInstanceCRN(),fluent.buildCredentialsSecretRef(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}