package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IdentityProviderStatusBuilder extends IdentityProviderStatusFluent<IdentityProviderStatusBuilder> implements VisitableBuilder<IdentityProviderStatus,IdentityProviderStatusBuilder>{
  public IdentityProviderStatusBuilder() {
    this(false);
  }
  public IdentityProviderStatusBuilder(Boolean validationEnabled) {
    this(new IdentityProviderStatus(), validationEnabled);
  }
  public IdentityProviderStatusBuilder(IdentityProviderStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IdentityProviderStatusBuilder(IdentityProviderStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IdentityProviderStatus(), validationEnabled);
  }
  public IdentityProviderStatusBuilder(IdentityProviderStatusFluent<?> fluent,IdentityProviderStatus instance) {
    this(fluent, instance, false);
  }
  public IdentityProviderStatusBuilder(IdentityProviderStatusFluent<?> fluent,IdentityProviderStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IdentityProviderStatus());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IdentityProviderStatusBuilder(IdentityProviderStatus instance) {
    this(instance,false);
  }
  public IdentityProviderStatusBuilder(IdentityProviderStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IdentityProviderStatus());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IdentityProviderStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IdentityProviderStatus build() {
    IdentityProviderStatus buildable = new IdentityProviderStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}