package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeconfigSecretReferenceBuilder extends KubeconfigSecretReferenceFluent<KubeconfigSecretReferenceBuilder> implements VisitableBuilder<KubeconfigSecretReference,KubeconfigSecretReferenceBuilder>{
  public KubeconfigSecretReferenceBuilder() {
    this(false);
  }
  public KubeconfigSecretReferenceBuilder(Boolean validationEnabled) {
    this(new KubeconfigSecretReference(), validationEnabled);
  }
  public KubeconfigSecretReferenceBuilder(KubeconfigSecretReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeconfigSecretReferenceBuilder(KubeconfigSecretReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeconfigSecretReference(), validationEnabled);
  }
  public KubeconfigSecretReferenceBuilder(KubeconfigSecretReferenceFluent<?> fluent,KubeconfigSecretReference instance) {
    this(fluent, instance, false);
  }
  public KubeconfigSecretReferenceBuilder(KubeconfigSecretReferenceFluent<?> fluent,KubeconfigSecretReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeconfigSecretReference());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeconfigSecretReferenceBuilder(KubeconfigSecretReference instance) {
    this(instance,false);
  }
  public KubeconfigSecretReferenceBuilder(KubeconfigSecretReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeconfigSecretReference());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeconfigSecretReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public KubeconfigSecretReference build() {
    KubeconfigSecretReference buildable = new KubeconfigSecretReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}