package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolAutoscalingBuilder extends MachinePoolAutoscalingFluent<MachinePoolAutoscalingBuilder> implements VisitableBuilder<MachinePoolAutoscaling,MachinePoolAutoscalingBuilder>{
  public MachinePoolAutoscalingBuilder() {
    this(false);
  }
  public MachinePoolAutoscalingBuilder(Boolean validationEnabled) {
    this(new MachinePoolAutoscaling(), validationEnabled);
  }
  public MachinePoolAutoscalingBuilder(MachinePoolAutoscalingFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolAutoscalingBuilder(MachinePoolAutoscalingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolAutoscaling(), validationEnabled);
  }
  public MachinePoolAutoscalingBuilder(MachinePoolAutoscalingFluent<?> fluent,MachinePoolAutoscaling instance) {
    this(fluent, instance, false);
  }
  public MachinePoolAutoscalingBuilder(MachinePoolAutoscalingFluent<?> fluent,MachinePoolAutoscaling instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePoolAutoscaling());

    if (instance != null) {
      fluent.withMaxReplicas(instance.getMaxReplicas());
      fluent.withMinReplicas(instance.getMinReplicas());
      fluent.withMaxReplicas(instance.getMaxReplicas());
      fluent.withMinReplicas(instance.getMinReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolAutoscalingBuilder(MachinePoolAutoscaling instance) {
    this(instance,false);
  }
  public MachinePoolAutoscalingBuilder(MachinePoolAutoscaling instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePoolAutoscaling());

    if (instance != null) {
      this.withMaxReplicas(instance.getMaxReplicas());
      this.withMinReplicas(instance.getMinReplicas());
      this.withMaxReplicas(instance.getMaxReplicas());
      this.withMinReplicas(instance.getMinReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolAutoscalingFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolAutoscaling build() {
    MachinePoolAutoscaling buildable = new MachinePoolAutoscaling(fluent.getMaxReplicas(),fluent.getMinReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}