package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolConditionBuilder extends MachinePoolConditionFluent<MachinePoolConditionBuilder> implements VisitableBuilder<MachinePoolCondition,MachinePoolConditionBuilder>{
  public MachinePoolConditionBuilder() {
    this(false);
  }
  public MachinePoolConditionBuilder(Boolean validationEnabled) {
    this(new MachinePoolCondition(), validationEnabled);
  }
  public MachinePoolConditionBuilder(MachinePoolConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolConditionBuilder(MachinePoolConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolCondition(), validationEnabled);
  }
  public MachinePoolConditionBuilder(MachinePoolConditionFluent<?> fluent,MachinePoolCondition instance) {
    this(fluent, instance, false);
  }
  public MachinePoolConditionBuilder(MachinePoolConditionFluent<?> fluent,MachinePoolCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePoolCondition());

    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolConditionBuilder(MachinePoolCondition instance) {
    this(instance,false);
  }
  public MachinePoolConditionBuilder(MachinePoolCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePoolCondition());

    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolConditionFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolCondition build() {
    MachinePoolCondition buildable = new MachinePoolCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}