package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolNameLeaseSpecBuilder extends MachinePoolNameLeaseSpecFluent<MachinePoolNameLeaseSpecBuilder> implements VisitableBuilder<MachinePoolNameLeaseSpec,MachinePoolNameLeaseSpecBuilder>{
  public MachinePoolNameLeaseSpecBuilder() {
    this(false);
  }
  public MachinePoolNameLeaseSpecBuilder(Boolean validationEnabled) {
    this(new MachinePoolNameLeaseSpec(), validationEnabled);
  }
  public MachinePoolNameLeaseSpecBuilder(MachinePoolNameLeaseSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolNameLeaseSpecBuilder(MachinePoolNameLeaseSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolNameLeaseSpec(), validationEnabled);
  }
  public MachinePoolNameLeaseSpecBuilder(MachinePoolNameLeaseSpecFluent<?> fluent,MachinePoolNameLeaseSpec instance) {
    this(fluent, instance, false);
  }
  public MachinePoolNameLeaseSpecBuilder(MachinePoolNameLeaseSpecFluent<?> fluent,MachinePoolNameLeaseSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePoolNameLeaseSpec());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolNameLeaseSpecBuilder(MachinePoolNameLeaseSpec instance) {
    this(instance,false);
  }
  public MachinePoolNameLeaseSpecBuilder(MachinePoolNameLeaseSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePoolNameLeaseSpec());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolNameLeaseSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolNameLeaseSpec build() {
    MachinePoolNameLeaseSpec buildable = new MachinePoolNameLeaseSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}