package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolPlatformBuilder extends MachinePoolPlatformFluent<MachinePoolPlatformBuilder> implements VisitableBuilder<MachinePoolPlatform,MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(false);
  }
  public MachinePoolPlatformBuilder(Boolean validationEnabled) {
    this(new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance) {
    this(fluent, instance, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachinePoolPlatform());

    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance) {
    this(instance,false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachinePoolPlatform());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withVsphere(instance.getVsphere());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolPlatformFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.buildAws(),fluent.buildAzure(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildOpenstack(),fluent.buildOvirt(),fluent.buildVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}