package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineSetStatusBuilder extends MachineSetStatusFluent<MachineSetStatusBuilder> implements VisitableBuilder<MachineSetStatus,MachineSetStatusBuilder>{
  public MachineSetStatusBuilder() {
    this(false);
  }
  public MachineSetStatusBuilder(Boolean validationEnabled) {
    this(new MachineSetStatus(), validationEnabled);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineSetStatus(), validationEnabled);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,MachineSetStatus instance) {
    this(fluent, instance, false);
  }
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,MachineSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachineSetStatus());

    if (instance != null) {
      fluent.withErrorMessage(instance.getErrorMessage());
      fluent.withErrorReason(instance.getErrorReason());
      fluent.withMaxReplicas(instance.getMaxReplicas());
      fluent.withMinReplicas(instance.getMinReplicas());
      fluent.withName(instance.getName());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withErrorMessage(instance.getErrorMessage());
      fluent.withErrorReason(instance.getErrorReason());
      fluent.withMaxReplicas(instance.getMaxReplicas());
      fluent.withMinReplicas(instance.getMinReplicas());
      fluent.withName(instance.getName());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineSetStatusBuilder(MachineSetStatus instance) {
    this(instance,false);
  }
  public MachineSetStatusBuilder(MachineSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachineSetStatus());

    if (instance != null) {
      this.withErrorMessage(instance.getErrorMessage());
      this.withErrorReason(instance.getErrorReason());
      this.withMaxReplicas(instance.getMaxReplicas());
      this.withMinReplicas(instance.getMinReplicas());
      this.withName(instance.getName());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withErrorMessage(instance.getErrorMessage());
      this.withErrorReason(instance.getErrorReason());
      this.withMaxReplicas(instance.getMaxReplicas());
      this.withMinReplicas(instance.getMinReplicas());
      this.withName(instance.getName());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachineSetStatus build() {
    MachineSetStatus buildable = new MachineSetStatus(fluent.getErrorMessage(),fluent.getErrorReason(),fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.getName(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}