package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManageDNSGCPConfigBuilder extends ManageDNSGCPConfigFluent<ManageDNSGCPConfigBuilder> implements VisitableBuilder<ManageDNSGCPConfig,ManageDNSGCPConfigBuilder>{
  public ManageDNSGCPConfigBuilder() {
    this(false);
  }
  public ManageDNSGCPConfigBuilder(Boolean validationEnabled) {
    this(new ManageDNSGCPConfig(), validationEnabled);
  }
  public ManageDNSGCPConfigBuilder(ManageDNSGCPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ManageDNSGCPConfigBuilder(ManageDNSGCPConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManageDNSGCPConfig(), validationEnabled);
  }
  public ManageDNSGCPConfigBuilder(ManageDNSGCPConfigFluent<?> fluent,ManageDNSGCPConfig instance) {
    this(fluent, instance, false);
  }
  public ManageDNSGCPConfigBuilder(ManageDNSGCPConfigFluent<?> fluent,ManageDNSGCPConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManageDNSGCPConfig());

    if (instance != null) {
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManageDNSGCPConfigBuilder(ManageDNSGCPConfig instance) {
    this(instance,false);
  }
  public ManageDNSGCPConfigBuilder(ManageDNSGCPConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManageDNSGCPConfig());

    if (instance != null) {
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManageDNSGCPConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ManageDNSGCPConfig build() {
    ManageDNSGCPConfig buildable = new ManageDNSGCPConfig(fluent.buildCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}