package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProvisioningBuilder extends ProvisioningFluent<ProvisioningBuilder> implements VisitableBuilder<Provisioning,ProvisioningBuilder>{
  public ProvisioningBuilder() {
    this(false);
  }
  public ProvisioningBuilder(Boolean validationEnabled) {
    this(new Provisioning(), validationEnabled);
  }
  public ProvisioningBuilder(ProvisioningFluent<?> fluent) {
    this(fluent, false);
  }
  public ProvisioningBuilder(ProvisioningFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Provisioning(), validationEnabled);
  }
  public ProvisioningBuilder(ProvisioningFluent<?> fluent,Provisioning instance) {
    this(fluent, instance, false);
  }
  public ProvisioningBuilder(ProvisioningFluent<?> fluent,Provisioning instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Provisioning());

    if (instance != null) {
      fluent.withImageSetRef(instance.getImageSetRef());
      fluent.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
      fluent.withInstallerEnv(instance.getInstallerEnv());
      fluent.withInstallerImageOverride(instance.getInstallerImageOverride());
      fluent.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
      fluent.withReleaseImage(instance.getReleaseImage());
      fluent.withSshKnownHosts(instance.getSshKnownHosts());
      fluent.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
      fluent.withImageSetRef(instance.getImageSetRef());
      fluent.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
      fluent.withInstallerEnv(instance.getInstallerEnv());
      fluent.withInstallerImageOverride(instance.getInstallerImageOverride());
      fluent.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
      fluent.withReleaseImage(instance.getReleaseImage());
      fluent.withSshKnownHosts(instance.getSshKnownHosts());
      fluent.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProvisioningBuilder(Provisioning instance) {
    this(instance,false);
  }
  public ProvisioningBuilder(Provisioning instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Provisioning());

    if (instance != null) {
      this.withImageSetRef(instance.getImageSetRef());
      this.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
      this.withInstallerEnv(instance.getInstallerEnv());
      this.withInstallerImageOverride(instance.getInstallerImageOverride());
      this.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
      this.withReleaseImage(instance.getReleaseImage());
      this.withSshKnownHosts(instance.getSshKnownHosts());
      this.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
      this.withImageSetRef(instance.getImageSetRef());
      this.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
      this.withInstallerEnv(instance.getInstallerEnv());
      this.withInstallerImageOverride(instance.getInstallerImageOverride());
      this.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
      this.withReleaseImage(instance.getReleaseImage());
      this.withSshKnownHosts(instance.getSshKnownHosts());
      this.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProvisioningFluent<?> fluent;
  Boolean validationEnabled;
  public Provisioning build() {
    Provisioning buildable = new Provisioning(fluent.buildImageSetRef(),fluent.buildInstallConfigSecretRef(),fluent.getInstallerEnv(),fluent.getInstallerImageOverride(),fluent.buildManifestsConfigMapRef(),fluent.getReleaseImage(),fluent.getSshKnownHosts(),fluent.buildSshPrivateKeySecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}