package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretMappingBuilder extends SecretMappingFluent<SecretMappingBuilder> implements VisitableBuilder<SecretMapping,SecretMappingBuilder>{
  public SecretMappingBuilder() {
    this(false);
  }
  public SecretMappingBuilder(Boolean validationEnabled) {
    this(new SecretMapping(), validationEnabled);
  }
  public SecretMappingBuilder(SecretMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretMappingBuilder(SecretMappingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretMapping(), validationEnabled);
  }
  public SecretMappingBuilder(SecretMappingFluent<?> fluent,SecretMapping instance) {
    this(fluent, instance, false);
  }
  public SecretMappingBuilder(SecretMappingFluent<?> fluent,SecretMapping instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretMapping());

    if (instance != null) {
      fluent.withSourceRef(instance.getSourceRef());
      fluent.withTargetRef(instance.getTargetRef());
      fluent.withSourceRef(instance.getSourceRef());
      fluent.withTargetRef(instance.getTargetRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretMappingBuilder(SecretMapping instance) {
    this(instance,false);
  }
  public SecretMappingBuilder(SecretMapping instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretMapping());

    if (instance != null) {
      this.withSourceRef(instance.getSourceRef());
      this.withTargetRef(instance.getTargetRef());
      this.withSourceRef(instance.getSourceRef());
      this.withTargetRef(instance.getTargetRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretMappingFluent<?> fluent;
  Boolean validationEnabled;
  public SecretMapping build() {
    SecretMapping buildable = new SecretMapping(fluent.buildSourceRef(),fluent.buildTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}