package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorSyncIdentityProviderBuilder extends SelectorSyncIdentityProviderFluent<SelectorSyncIdentityProviderBuilder> implements VisitableBuilder<SelectorSyncIdentityProvider,SelectorSyncIdentityProviderBuilder>{
  public SelectorSyncIdentityProviderBuilder() {
    this(false);
  }
  public SelectorSyncIdentityProviderBuilder(Boolean validationEnabled) {
    this(new SelectorSyncIdentityProvider(), validationEnabled);
  }
  public SelectorSyncIdentityProviderBuilder(SelectorSyncIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorSyncIdentityProviderBuilder(SelectorSyncIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelectorSyncIdentityProvider(), validationEnabled);
  }
  public SelectorSyncIdentityProviderBuilder(SelectorSyncIdentityProviderFluent<?> fluent,SelectorSyncIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public SelectorSyncIdentityProviderBuilder(SelectorSyncIdentityProviderFluent<?> fluent,SelectorSyncIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SelectorSyncIdentityProvider());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelectorSyncIdentityProviderBuilder(SelectorSyncIdentityProvider instance) {
    this(instance,false);
  }
  public SelectorSyncIdentityProviderBuilder(SelectorSyncIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SelectorSyncIdentityProvider());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelectorSyncIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public SelectorSyncIdentityProvider build() {
    SelectorSyncIdentityProvider buildable = new SelectorSyncIdentityProvider(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}