package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorSyncIdentityProviderSpecBuilder extends SelectorSyncIdentityProviderSpecFluent<SelectorSyncIdentityProviderSpecBuilder> implements VisitableBuilder<SelectorSyncIdentityProviderSpec,SelectorSyncIdentityProviderSpecBuilder>{
  public SelectorSyncIdentityProviderSpecBuilder() {
    this(false);
  }
  public SelectorSyncIdentityProviderSpecBuilder(Boolean validationEnabled) {
    this(new SelectorSyncIdentityProviderSpec(), validationEnabled);
  }
  public SelectorSyncIdentityProviderSpecBuilder(SelectorSyncIdentityProviderSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorSyncIdentityProviderSpecBuilder(SelectorSyncIdentityProviderSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelectorSyncIdentityProviderSpec(), validationEnabled);
  }
  public SelectorSyncIdentityProviderSpecBuilder(SelectorSyncIdentityProviderSpecFluent<?> fluent,SelectorSyncIdentityProviderSpec instance) {
    this(fluent, instance, false);
  }
  public SelectorSyncIdentityProviderSpecBuilder(SelectorSyncIdentityProviderSpecFluent<?> fluent,SelectorSyncIdentityProviderSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SelectorSyncIdentityProviderSpec());

    if (instance != null) {
      fluent.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      fluent.withIdentityProviders(instance.getIdentityProviders());
      fluent.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      fluent.withIdentityProviders(instance.getIdentityProviders());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelectorSyncIdentityProviderSpecBuilder(SelectorSyncIdentityProviderSpec instance) {
    this(instance,false);
  }
  public SelectorSyncIdentityProviderSpecBuilder(SelectorSyncIdentityProviderSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SelectorSyncIdentityProviderSpec());

    if (instance != null) {
      this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      this.withIdentityProviders(instance.getIdentityProviders());
      this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      this.withIdentityProviders(instance.getIdentityProviders());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelectorSyncIdentityProviderSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SelectorSyncIdentityProviderSpec build() {
    SelectorSyncIdentityProviderSpec buildable = new SelectorSyncIdentityProviderSpec(fluent.buildClusterDeploymentSelector(),fluent.getIdentityProviders());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}