package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SelectorSyncSetSpecFluent<A extends SelectorSyncSetSpecFluent<A>> extends BaseFluent<A>{
  public SelectorSyncSetSpecFluent() {
  }
  public SelectorSyncSetSpecFluent(SelectorSyncSetSpec instance) {
    instance = (instance != null ? instance : new SelectorSyncSetSpec());

    if (instance != null) {
      this.withApplyBehavior(instance.getApplyBehavior());
      this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      this.withPatches(instance.getPatches());
      this.withResourceApplyMode(instance.getResourceApplyMode());
      this.withResources(instance.getResources());
      this.withSecretMappings(instance.getSecretMappings());
      this.withApplyBehavior(instance.getApplyBehavior());
      this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
      this.withPatches(instance.getPatches());
      this.withResourceApplyMode(instance.getResourceApplyMode());
      this.withResources(instance.getResources());
      this.withSecretMappings(instance.getSecretMappings());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String applyBehavior;
  private LabelSelectorBuilder clusterDeploymentSelector;
  private ArrayList<SyncObjectPatchBuilder> patches = new ArrayList<SyncObjectPatchBuilder>();
  private String resourceApplyMode;
  private List<Map<String,Object>> resources = new ArrayList<Map<String,Object>>();
  private ArrayList<SecretMappingBuilder> secretMappings = new ArrayList<SecretMappingBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApplyBehavior() {
    return this.applyBehavior;
  }
  public A withApplyBehavior(String applyBehavior) {
    this.applyBehavior=applyBehavior; return (A) this;
  }
  public boolean hasApplyBehavior() {
    return this.applyBehavior != null;
  }
  public LabelSelector buildClusterDeploymentSelector() {
    return this.clusterDeploymentSelector!=null ?this.clusterDeploymentSelector.build():null;
  }
  public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
    _visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
    if (clusterDeploymentSelector!=null){ this.clusterDeploymentSelector= new LabelSelectorBuilder(clusterDeploymentSelector); _visitables.get("clusterDeploymentSelector").add(this.clusterDeploymentSelector);} else { this.clusterDeploymentSelector = null; _visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector); } return (A) this;
  }
  public boolean hasClusterDeploymentSelector() {
    return this.clusterDeploymentSelector != null;
  }
  public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
    return new ClusterDeploymentSelectorNested(null);
  }
  public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
    return new ClusterDeploymentSelectorNested(item);
  }
  public ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(java.util.Optional.ofNullable(buildClusterDeploymentSelector()).orElse(null));
  }
  public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(java.util.Optional.ofNullable(buildClusterDeploymentSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
    return withNewClusterDeploymentSelectorLike(java.util.Optional.ofNullable(buildClusterDeploymentSelector()).orElse(item));
  }
  public A addToPatches(int index,SyncObjectPatch item) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
    if (index < 0 || index >= patches.size()) { _visitables.get("patches").add(builder); patches.add(builder); } else { _visitables.get("patches").add(index, builder); patches.add(index, builder);}
    return (A)this;
  }
  public A setToPatches(int index,SyncObjectPatch item) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
    if (index < 0 || index >= patches.size()) { _visitables.get("patches").add(builder); patches.add(builder); } else { _visitables.get("patches").set(index, builder); patches.set(index, builder);}
    return (A)this;
  }
  public A addToPatches(io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch... items) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").add(builder);this.patches.add(builder);} return (A)this;
  }
  public A addAllToPatches(Collection<SyncObjectPatch> items) {
    if (this.patches == null) {this.patches = new ArrayList<SyncObjectPatchBuilder>();}
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").add(builder);this.patches.add(builder);} return (A)this;
  }
  public A removeFromPatches(io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch... items) {
    if (this.patches == null) return (A)this;
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").remove(builder); this.patches.remove(builder);} return (A)this;
  }
  public A removeAllFromPatches(Collection<SyncObjectPatch> items) {
    if (this.patches == null) return (A)this;
    for (SyncObjectPatch item : items) {SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);_visitables.get("patches").remove(builder); this.patches.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPatches(Predicate<SyncObjectPatchBuilder> predicate) {
    if (patches == null) return (A) this;
    final Iterator<SyncObjectPatchBuilder> each = patches.iterator();
    final List visitables = _visitables.get("patches");
    while (each.hasNext()) {
      SyncObjectPatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<SyncObjectPatch> buildPatches() {
    return patches != null ? build(patches) : null;
  }
  public SyncObjectPatch buildPatch(int index) {
    return this.patches.get(index).build();
  }
  public SyncObjectPatch buildFirstPatch() {
    return this.patches.get(0).build();
  }
  public SyncObjectPatch buildLastPatch() {
    return this.patches.get(patches.size() - 1).build();
  }
  public SyncObjectPatch buildMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
    for (SyncObjectPatchBuilder item: patches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
    for (SyncObjectPatchBuilder item: patches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPatches(List<SyncObjectPatch> patches) {
    if (this.patches != null) { _visitables.get("patches").clear();}
    if (patches != null) {this.patches = new ArrayList(); for (SyncObjectPatch item : patches){this.addToPatches(item);}} else { this.patches = null;} return (A) this;
  }
  public A withPatches(io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch... patches) {
    if (this.patches != null) {this.patches.clear(); _visitables.remove("patches"); }
    if (patches != null) {for (SyncObjectPatch item :patches){ this.addToPatches(item);}} return (A) this;
  }
  public boolean hasPatches() {
    return patches != null && !patches.isEmpty();
  }
  public PatchesNested<A> addNewPatch() {
    return new PatchesNested(-1, null);
  }
  public PatchesNested<A> addNewPatchLike(SyncObjectPatch item) {
    return new PatchesNested(-1, item);
  }
  public PatchesNested<A> setNewPatchLike(int index,SyncObjectPatch item) {
    return new PatchesNested(index, item);
  }
  public PatchesNested<A> editPatch(int index) {
    if (patches.size() <= index) throw new RuntimeException("Can't edit patches. Index exceeds size.");
    return setNewPatchLike(index, buildPatch(index));
  }
  public PatchesNested<A> editFirstPatch() {
    if (patches.size() == 0) throw new RuntimeException("Can't edit first patches. The list is empty.");
    return setNewPatchLike(0, buildPatch(0));
  }
  public PatchesNested<A> editLastPatch() {
    int index = patches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last patches. The list is empty.");
    return setNewPatchLike(index, buildPatch(index));
  }
  public PatchesNested<A> editMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<patches.size();i++) { 
    if (predicate.test(patches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching patches. No match found.");
    return setNewPatchLike(index, buildPatch(index));
  }
  public String getResourceApplyMode() {
    return this.resourceApplyMode;
  }
  public A withResourceApplyMode(String resourceApplyMode) {
    this.resourceApplyMode=resourceApplyMode; return (A) this;
  }
  public boolean hasResourceApplyMode() {
    return this.resourceApplyMode != null;
  }
  public A addToResources(int index,Map<String,Object> item) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(int index,Map<String,Object> item) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(Map<String,Object>... items) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<Map<String,Object>> items) {
    if (this.resources == null) {this.resources = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(Map<String,Object>... items) {
    if (this.resources == null) return (A)this;
    for (Map<String,Object> item : items) { this.resources.remove(item);} return (A)this;
  }
  public A removeAllFromResources(Collection<Map<String,Object>> items) {
    if (this.resources == null) return (A)this;
    for (Map<String,Object> item : items) { this.resources.remove(item);} return (A)this;
  }
  public List<Map<String,Object>> getResources() {
    return this.resources;
  }
  public Map<String,Object> getResource(int index) {
    return this.resources.get(index);
  }
  public Map<String,Object> getFirstResource() {
    return this.resources.get(0);
  }
  public Map<String,Object> getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public Map<String,Object> getMatchingResource(Predicate<Map<String,Object>> predicate) {
    for (Map<String,Object> item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingResource(Predicate<Map<String,Object>> predicate) {
    for (Map<String,Object> item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public <K,V>A withResources(List<Map<String,Object>> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (Map<String,Object> item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(Map<String,Object>... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (Map<String,Object> item :resources){ this.addToResources(item);}} return (A) this;
  }
  public boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToSecretMappings(int index,SecretMapping item) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    SecretMappingBuilder builder = new SecretMappingBuilder(item);
    if (index < 0 || index >= secretMappings.size()) { _visitables.get("secretMappings").add(builder); secretMappings.add(builder); } else { _visitables.get("secretMappings").add(index, builder); secretMappings.add(index, builder);}
    return (A)this;
  }
  public A setToSecretMappings(int index,SecretMapping item) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    SecretMappingBuilder builder = new SecretMappingBuilder(item);
    if (index < 0 || index >= secretMappings.size()) { _visitables.get("secretMappings").add(builder); secretMappings.add(builder); } else { _visitables.get("secretMappings").set(index, builder); secretMappings.set(index, builder);}
    return (A)this;
  }
  public A addToSecretMappings(io.fabric8.openshift.api.model.hive.v1.SecretMapping... items) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").add(builder);this.secretMappings.add(builder);} return (A)this;
  }
  public A addAllToSecretMappings(Collection<SecretMapping> items) {
    if (this.secretMappings == null) {this.secretMappings = new ArrayList<SecretMappingBuilder>();}
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").add(builder);this.secretMappings.add(builder);} return (A)this;
  }
  public A removeFromSecretMappings(io.fabric8.openshift.api.model.hive.v1.SecretMapping... items) {
    if (this.secretMappings == null) return (A)this;
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").remove(builder); this.secretMappings.remove(builder);} return (A)this;
  }
  public A removeAllFromSecretMappings(Collection<SecretMapping> items) {
    if (this.secretMappings == null) return (A)this;
    for (SecretMapping item : items) {SecretMappingBuilder builder = new SecretMappingBuilder(item);_visitables.get("secretMappings").remove(builder); this.secretMappings.remove(builder);} return (A)this;
  }
  public A removeMatchingFromSecretMappings(Predicate<SecretMappingBuilder> predicate) {
    if (secretMappings == null) return (A) this;
    final Iterator<SecretMappingBuilder> each = secretMappings.iterator();
    final List visitables = _visitables.get("secretMappings");
    while (each.hasNext()) {
      SecretMappingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<SecretMapping> buildSecretMappings() {
    return secretMappings != null ? build(secretMappings) : null;
  }
  public SecretMapping buildSecretMapping(int index) {
    return this.secretMappings.get(index).build();
  }
  public SecretMapping buildFirstSecretMapping() {
    return this.secretMappings.get(0).build();
  }
  public SecretMapping buildLastSecretMapping() {
    return this.secretMappings.get(secretMappings.size() - 1).build();
  }
  public SecretMapping buildMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
    for (SecretMappingBuilder item: secretMappings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
    for (SecretMappingBuilder item: secretMappings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecretMappings(List<SecretMapping> secretMappings) {
    if (this.secretMappings != null) { _visitables.get("secretMappings").clear();}
    if (secretMappings != null) {this.secretMappings = new ArrayList(); for (SecretMapping item : secretMappings){this.addToSecretMappings(item);}} else { this.secretMappings = null;} return (A) this;
  }
  public A withSecretMappings(io.fabric8.openshift.api.model.hive.v1.SecretMapping... secretMappings) {
    if (this.secretMappings != null) {this.secretMappings.clear(); _visitables.remove("secretMappings"); }
    if (secretMappings != null) {for (SecretMapping item :secretMappings){ this.addToSecretMappings(item);}} return (A) this;
  }
  public boolean hasSecretMappings() {
    return secretMappings != null && !secretMappings.isEmpty();
  }
  public SecretMappingsNested<A> addNewSecretMapping() {
    return new SecretMappingsNested(-1, null);
  }
  public SecretMappingsNested<A> addNewSecretMappingLike(SecretMapping item) {
    return new SecretMappingsNested(-1, item);
  }
  public SecretMappingsNested<A> setNewSecretMappingLike(int index,SecretMapping item) {
    return new SecretMappingsNested(index, item);
  }
  public SecretMappingsNested<A> editSecretMapping(int index) {
    if (secretMappings.size() <= index) throw new RuntimeException("Can't edit secretMappings. Index exceeds size.");
    return setNewSecretMappingLike(index, buildSecretMapping(index));
  }
  public SecretMappingsNested<A> editFirstSecretMapping() {
    if (secretMappings.size() == 0) throw new RuntimeException("Can't edit first secretMappings. The list is empty.");
    return setNewSecretMappingLike(0, buildSecretMapping(0));
  }
  public SecretMappingsNested<A> editLastSecretMapping() {
    int index = secretMappings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secretMappings. The list is empty.");
    return setNewSecretMappingLike(index, buildSecretMapping(index));
  }
  public SecretMappingsNested<A> editMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secretMappings.size();i++) { 
    if (predicate.test(secretMappings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secretMappings. No match found.");
    return setNewSecretMappingLike(index, buildSecretMapping(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SelectorSyncSetSpecFluent that = (SelectorSyncSetSpecFluent) o;
    if (!java.util.Objects.equals(applyBehavior, that.applyBehavior)) return false;

    if (!java.util.Objects.equals(clusterDeploymentSelector, that.clusterDeploymentSelector)) return false;

    if (!java.util.Objects.equals(patches, that.patches)) return false;

    if (!java.util.Objects.equals(resourceApplyMode, that.resourceApplyMode)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(secretMappings, that.secretMappings)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(applyBehavior,  clusterDeploymentSelector,  patches,  resourceApplyMode,  resources,  secretMappings,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applyBehavior != null) { sb.append("applyBehavior:"); sb.append(applyBehavior + ","); }
    if (clusterDeploymentSelector != null) { sb.append("clusterDeploymentSelector:"); sb.append(clusterDeploymentSelector + ","); }
    if (patches != null && !patches.isEmpty()) { sb.append("patches:"); sb.append(patches + ","); }
    if (resourceApplyMode != null) { sb.append("resourceApplyMode:"); sb.append(resourceApplyMode + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (secretMappings != null && !secretMappings.isEmpty()) { sb.append("secretMappings:"); sb.append(secretMappings + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterDeploymentSelectorNested<N> extends LabelSelectorFluent<ClusterDeploymentSelectorNested<N>> implements Nested<N>{
    ClusterDeploymentSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) SelectorSyncSetSpecFluent.this.withClusterDeploymentSelector(builder.build());
    }
    public N endClusterDeploymentSelector() {
      return and();
    }
    
  }
  public class PatchesNested<N> extends SyncObjectPatchFluent<PatchesNested<N>> implements Nested<N>{
    PatchesNested(int index,SyncObjectPatch item) {
      this.index = index;
      this.builder = new SyncObjectPatchBuilder(this, item);
    }
    SyncObjectPatchBuilder builder;
    int index;
    public N and() {
      return (N) SelectorSyncSetSpecFluent.this.setToPatches(index,builder.build());
    }
    public N endPatch() {
      return and();
    }
    
  }
  public class SecretMappingsNested<N> extends SecretMappingFluent<SecretMappingsNested<N>> implements Nested<N>{
    SecretMappingsNested(int index,SecretMapping item) {
      this.index = index;
      this.builder = new SecretMappingBuilder(this, item);
    }
    SecretMappingBuilder builder;
    int index;
    public N and() {
      return (N) SelectorSyncSetSpecFluent.this.setToSecretMappings(index,builder.build());
    }
    public N endSecretMapping() {
      return and();
    }
    
  }
  
}