package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorSyncSetStatusBuilder extends SelectorSyncSetStatusFluent<SelectorSyncSetStatusBuilder> implements VisitableBuilder<SelectorSyncSetStatus,SelectorSyncSetStatusBuilder>{
  public SelectorSyncSetStatusBuilder() {
    this(false);
  }
  public SelectorSyncSetStatusBuilder(Boolean validationEnabled) {
    this(new SelectorSyncSetStatus(), validationEnabled);
  }
  public SelectorSyncSetStatusBuilder(SelectorSyncSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorSyncSetStatusBuilder(SelectorSyncSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelectorSyncSetStatus(), validationEnabled);
  }
  public SelectorSyncSetStatusBuilder(SelectorSyncSetStatusFluent<?> fluent,SelectorSyncSetStatus instance) {
    this(fluent, instance, false);
  }
  public SelectorSyncSetStatusBuilder(SelectorSyncSetStatusFluent<?> fluent,SelectorSyncSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SelectorSyncSetStatus());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelectorSyncSetStatusBuilder(SelectorSyncSetStatus instance) {
    this(instance,false);
  }
  public SelectorSyncSetStatusBuilder(SelectorSyncSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SelectorSyncSetStatus());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelectorSyncSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SelectorSyncSetStatus build() {
    SelectorSyncSetStatus buildable = new SelectorSyncSetStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}