package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncIdentityProviderBuilder extends SyncIdentityProviderFluent<SyncIdentityProviderBuilder> implements VisitableBuilder<SyncIdentityProvider,SyncIdentityProviderBuilder>{
  public SyncIdentityProviderBuilder() {
    this(false);
  }
  public SyncIdentityProviderBuilder(Boolean validationEnabled) {
    this(new SyncIdentityProvider(), validationEnabled);
  }
  public SyncIdentityProviderBuilder(SyncIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncIdentityProviderBuilder(SyncIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncIdentityProvider(), validationEnabled);
  }
  public SyncIdentityProviderBuilder(SyncIdentityProviderFluent<?> fluent,SyncIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public SyncIdentityProviderBuilder(SyncIdentityProviderFluent<?> fluent,SyncIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SyncIdentityProvider());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncIdentityProviderBuilder(SyncIdentityProvider instance) {
    this(instance,false);
  }
  public SyncIdentityProviderBuilder(SyncIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SyncIdentityProvider());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public SyncIdentityProvider build() {
    SyncIdentityProvider buildable = new SyncIdentityProvider(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}