package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncIdentityProviderSpecBuilder extends SyncIdentityProviderSpecFluent<SyncIdentityProviderSpecBuilder> implements VisitableBuilder<SyncIdentityProviderSpec,SyncIdentityProviderSpecBuilder>{
  public SyncIdentityProviderSpecBuilder() {
    this(false);
  }
  public SyncIdentityProviderSpecBuilder(Boolean validationEnabled) {
    this(new SyncIdentityProviderSpec(), validationEnabled);
  }
  public SyncIdentityProviderSpecBuilder(SyncIdentityProviderSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncIdentityProviderSpecBuilder(SyncIdentityProviderSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncIdentityProviderSpec(), validationEnabled);
  }
  public SyncIdentityProviderSpecBuilder(SyncIdentityProviderSpecFluent<?> fluent,SyncIdentityProviderSpec instance) {
    this(fluent, instance, false);
  }
  public SyncIdentityProviderSpecBuilder(SyncIdentityProviderSpecFluent<?> fluent,SyncIdentityProviderSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SyncIdentityProviderSpec());

    if (instance != null) {
      fluent.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
      fluent.withIdentityProviders(instance.getIdentityProviders());
      fluent.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
      fluent.withIdentityProviders(instance.getIdentityProviders());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncIdentityProviderSpecBuilder(SyncIdentityProviderSpec instance) {
    this(instance,false);
  }
  public SyncIdentityProviderSpecBuilder(SyncIdentityProviderSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SyncIdentityProviderSpec());

    if (instance != null) {
      this.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
      this.withIdentityProviders(instance.getIdentityProviders());
      this.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
      this.withIdentityProviders(instance.getIdentityProviders());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncIdentityProviderSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SyncIdentityProviderSpec build() {
    SyncIdentityProviderSpec buildable = new SyncIdentityProviderSpec(fluent.buildClusterDeploymentRefs(),fluent.getIdentityProviders());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}