package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncObjectPatchBuilder extends SyncObjectPatchFluent<SyncObjectPatchBuilder> implements VisitableBuilder<SyncObjectPatch,SyncObjectPatchBuilder>{
  public SyncObjectPatchBuilder() {
    this(false);
  }
  public SyncObjectPatchBuilder(Boolean validationEnabled) {
    this(new SyncObjectPatch(), validationEnabled);
  }
  public SyncObjectPatchBuilder(SyncObjectPatchFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncObjectPatchBuilder(SyncObjectPatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncObjectPatch(), validationEnabled);
  }
  public SyncObjectPatchBuilder(SyncObjectPatchFluent<?> fluent,SyncObjectPatch instance) {
    this(fluent, instance, false);
  }
  public SyncObjectPatchBuilder(SyncObjectPatchFluent<?> fluent,SyncObjectPatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SyncObjectPatch());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPatch(instance.getPatch());
      fluent.withPatchType(instance.getPatchType());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPatch(instance.getPatch());
      fluent.withPatchType(instance.getPatchType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncObjectPatchBuilder(SyncObjectPatch instance) {
    this(instance,false);
  }
  public SyncObjectPatchBuilder(SyncObjectPatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SyncObjectPatch());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPatch(instance.getPatch());
      this.withPatchType(instance.getPatchType());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPatch(instance.getPatch());
      this.withPatchType(instance.getPatchType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncObjectPatchFluent<?> fluent;
  Boolean validationEnabled;
  public SyncObjectPatch build() {
    SyncObjectPatch buildable = new SyncObjectPatch(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPatch(),fluent.getPatchType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}