package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncSetBuilder extends SyncSetFluent<SyncSetBuilder> implements VisitableBuilder<SyncSet,SyncSetBuilder>{
  public SyncSetBuilder() {
    this(false);
  }
  public SyncSetBuilder(Boolean validationEnabled) {
    this(new SyncSet(), validationEnabled);
  }
  public SyncSetBuilder(SyncSetFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncSetBuilder(SyncSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncSet(), validationEnabled);
  }
  public SyncSetBuilder(SyncSetFluent<?> fluent,SyncSet instance) {
    this(fluent, instance, false);
  }
  public SyncSetBuilder(SyncSetFluent<?> fluent,SyncSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SyncSet());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncSetBuilder(SyncSet instance) {
    this(instance,false);
  }
  public SyncSetBuilder(SyncSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SyncSet());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncSetFluent<?> fluent;
  Boolean validationEnabled;
  public SyncSet build() {
    SyncSet buildable = new SyncSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}