package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyncSetStatusBuilder extends SyncSetStatusFluent<SyncSetStatusBuilder> implements VisitableBuilder<SyncSetStatus,SyncSetStatusBuilder>{
  public SyncSetStatusBuilder() {
    this(false);
  }
  public SyncSetStatusBuilder(Boolean validationEnabled) {
    this(new SyncSetStatus(), validationEnabled);
  }
  public SyncSetStatusBuilder(SyncSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SyncSetStatusBuilder(SyncSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyncSetStatus(), validationEnabled);
  }
  public SyncSetStatusBuilder(SyncSetStatusFluent<?> fluent,SyncSetStatus instance) {
    this(fluent, instance, false);
  }
  public SyncSetStatusBuilder(SyncSetStatusFluent<?> fluent,SyncSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SyncSetStatus());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyncSetStatusBuilder(SyncSetStatus instance) {
    this(instance,false);
  }
  public SyncSetStatusBuilder(SyncSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SyncSetStatus());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyncSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SyncSetStatus build() {
    SyncSetStatus buildable = new SyncSetStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}