package io.fabric8.openshift.api.model.hive.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzurePlatformBuilder extends AzurePlatformFluent<AzurePlatformBuilder> implements VisitableBuilder<AzurePlatform,AzurePlatformBuilder>{
  public AzurePlatformBuilder() {
    this(new AzurePlatform());
  }
  
  public AzurePlatformBuilder(AzurePlatformFluent<?> fluent) {
    this(fluent, new AzurePlatform());
  }
  
  public AzurePlatformBuilder(AzurePlatformFluent<?> fluent,AzurePlatform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzurePlatformBuilder(AzurePlatform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzurePlatformFluent<?> fluent;
  
  public AzurePlatform build() {
    AzurePlatform buildable = new AzurePlatform(fluent.getBaseDomainResourceGroupName(),fluent.getCloudName(),fluent.buildCredentialsSecretRef(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}